/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.repository;

import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.RepositoryOperation;
import org.dizitart.no2.RemoveOptions;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;

public class RemoveRepositoryOperation
extends AbstractNitriteOperation
implements RepositoryOperation {
    private ObjectFilter filter;
    private RemoveOptions removeOptions;

    public RemoveRepositoryOperation(ObjectFilter filter) {
        this.filter = filter;
    }

    public RemoveRepositoryOperation(ObjectFilter filter, RemoveOptions removeOptions) {
        this.filter = filter;
        this.removeOptions = removeOptions;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        ObjectRepository repository = (ObjectRepository)endpoint.getNitriteCollection();
        if (this.filter != null && this.removeOptions != null) {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", (Object)repository.remove(this.filter, this.removeOptions));
        } else {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", (Object)repository.remove(this.filter));
        }
    }
}

