/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import java.util.Map;
import javax.jms.ConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sjms.batch.SjmsBatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="sjms-batch")
public class SjmsBatchComponent
extends HeaderFilterStrategyComponent {
    @Metadata(label="advanced")
    private ConnectionFactory connectionFactory;
    @Metadata(label="advanced")
    private boolean asyncStartListener;
    @Metadata(label="advanced", defaultValue="5000")
    private int recoveryInterval = 5000;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ConnectionFactory cf = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(parameters, "connectionFactory", ConnectionFactory.class);
        if (cf != null) {
            this.setConnectionFactory(cf);
        }
        ObjectHelper.notNull((Object)this.connectionFactory, (String)"connectionFactory");
        SjmsBatchEndpoint answer = new SjmsBatchEndpoint(uri, (Component)this, remaining);
        answer.setAsyncStartListener(this.isAsyncStartListener());
        answer.setRecoveryInterval(this.getRecoveryInterval());
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public int getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(int recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }
}

