/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class StreamEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":kind";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "stream".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "kind", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(21);
        props.add("groupLines");
        props.add("fileName");
        props.add("kind");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("fileWatcher");
        props.add("closeOnDone");
        props.add("encoding");
        props.add("initialPromptDelay");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("scanStream");
        props.add("delay");
        props.add("promptDelay");
        props.add("readTimeout");
        props.add("groupStrategy");
        props.add("promptMessage");
        props.add("exceptionHandler");
        props.add("retry");
        props.add("scanStreamDelay");
        props.add("autoCloseCount");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

