/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;
import org.apache.camel.CamelException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jt400.Jt400Component;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400DataQueueConsumer;
import org.apache.camel.component.jt400.Jt400DataQueueProducer;
import org.apache.camel.component.jt400.Jt400MsgQueueConsumer;
import org.apache.camel.component.jt400.Jt400MsgQueueProducer;
import org.apache.camel.component.jt400.Jt400PgmProducer;
import org.apache.camel.component.jt400.Jt400Type;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@UriEndpoint(firstVersion="1.5.0", scheme="jt400", title="JT400", syntax="jt400:userID:password/systemName/objectPath.type", category={Category.MESSAGING})
public class Jt400Endpoint
extends ScheduledPollEndpoint
implements MultipleConsumersSupport {
    public static final String KEY = "KEY";
    public static final String SENDER_INFORMATION = "SENDER_INFORMATION";
    @UriParam
    private final Jt400Configuration configuration;

    protected Jt400Endpoint(String endpointUri, Jt400Component component) throws CamelException {
        this(endpointUri, component, component.getConnectionPool());
    }

    protected Jt400Endpoint(String endpointUri, Jt400Component component, AS400ConnectionPool connectionPool) throws CamelException {
        super(endpointUri, (Component)component);
        ObjectHelper.notNull((Object)connectionPool, (String)"connectionPool");
        try {
            this.configuration = new Jt400Configuration(endpointUri, connectionPool);
        }
        catch (URISyntaxException e) {
            throw new CamelException("Unable to parse URI for " + URISupport.sanitizeUri((String)endpointUri), (Throwable)e);
        }
    }

    public Jt400Configuration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        if (Jt400Type.DTAQ == this.configuration.getType()) {
            return new Jt400DataQueueProducer(this);
        }
        if (Jt400Type.MSGQ == this.configuration.getType()) {
            return new Jt400MsgQueueProducer(this);
        }
        return new Jt400PgmProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (Jt400Type.DTAQ == this.configuration.getType()) {
            Jt400DataQueueConsumer consumer = new Jt400DataQueueConsumer(this, processor);
            this.configureConsumer((Consumer)consumer);
            return consumer;
        }
        if (Jt400Type.MSGQ == this.configuration.getType()) {
            Jt400MsgQueueConsumer consumer = new Jt400MsgQueueConsumer(this, processor);
            this.configureConsumer((Consumer)consumer);
            return consumer;
        }
        throw new OperationNotSupportedException();
    }

    protected AS400 getSystem() {
        return this.configuration.getConnection();
    }

    protected void releaseSystem(AS400 system) {
        this.configuration.releaseConnection(system);
    }

    protected String getObjectPath() {
        return this.configuration.getObjectPath();
    }

    public Jt400Type getType() {
        return this.configuration.getType();
    }

    public void setType(Jt400Type type) {
        this.configuration.setType(type);
    }

    public String getSearchKey() {
        return this.configuration.getSearchKey();
    }

    public boolean isKeyed() {
        return this.configuration.isKeyed();
    }

    public Integer[] getOutputFieldsIdxArray() {
        return this.configuration.getOutputFieldsIdxArray();
    }

    public int getCcsid() {
        return this.configuration.getCcsid();
    }

    public void setOutputFieldsIdxArray(Integer[] outputFieldsIdxArray) {
        this.configuration.setOutputFieldsIdxArray(outputFieldsIdxArray);
    }

    public void setSearchKey(String searchKey) {
        this.configuration.setSearchKey(searchKey);
    }

    public void setOutputFieldsIdx(String outputFieldsIdx) {
        this.configuration.setOutputFieldsIdx(outputFieldsIdx);
    }

    public void setKeyed(boolean keyed) {
        this.configuration.setKeyed(keyed);
    }

    public Integer[] getOutputFieldsLengthArray() {
        return this.configuration.getOutputFieldsLengthArray();
    }

    public void setSearchType(Jt400Configuration.SearchType searchType) {
        this.configuration.setSearchType(searchType);
    }

    public boolean isGuiAvailable() {
        return this.configuration.isGuiAvailable();
    }

    public void setFormat(Jt400Configuration.Format format) {
        this.configuration.setFormat(format);
    }

    public void setFieldsLength(String fieldsLength) {
        this.configuration.setFieldsLength(fieldsLength);
    }

    public Jt400Configuration.Format getFormat() {
        return this.configuration.getFormat();
    }

    public void setOutputFieldsLengthArray(Integer[] outputFieldsLengthArray) {
        this.configuration.setOutputFieldsLengthArray(outputFieldsLengthArray);
    }

    public int getCssid() {
        return this.configuration.getCssid();
    }

    public String getUserID() {
        return this.configuration.getUserID();
    }

    public Jt400Configuration.SearchType getSearchType() {
        return this.configuration.getSearchType();
    }

    public void setCcsid(int ccsid) {
        this.configuration.setCcsid(ccsid);
    }

    public void setGuiAvailable(boolean guiAvailable) {
        this.configuration.setGuiAvailable(guiAvailable);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public String getSystemName() {
        return this.configuration.getSystemName();
    }

    public boolean isFieldIdxForOuput(int idx) {
        return Arrays.binarySearch((Object[])this.getOutputFieldsIdxArray(), (Object)idx) >= 0;
    }

    public int getOutputFieldLength(int idx) {
        return this.configuration.getOutputFieldsLengthArray()[idx];
    }

    public void setObjectPath(String objectPath) {
        this.configuration.setObjectPath(objectPath);
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public void setUserID(String userID) {
        this.configuration.setUserID(userID);
    }

    public void setSystemName(String systemName) {
        this.configuration.setSystemName(systemName);
    }

    public void setSecured(boolean secured) {
        this.configuration.setSecured(secured);
    }

    public boolean isSecured() {
        return this.configuration.isSecured();
    }

    public int getReadTimeout() {
        return this.configuration.getReadTimeout();
    }

    public void setReadTimeout(int readTimeout) {
        this.configuration.setReadTimeout(readTimeout);
    }

    public void setProcedureName(String procedureName) {
        this.configuration.setProcedureName(procedureName);
    }

    public String getProcedureName() {
        return this.configuration.getProcedureName();
    }

    public void setMessageAction(Jt400Configuration.MessageAction messageAction) {
        this.configuration.setMessageAction(messageAction);
    }

    public Jt400Configuration.MessageAction getMessageAction() {
        return this.configuration.getMessageAction();
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }
}

