/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.Map;
import java.util.Properties;
import javax.cache.configuration.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;

@Component(value="jcache")
public class JCacheComponent
extends DefaultComponent {
    @Metadata
    private String cachingProvider;
    @Metadata
    private Configuration cacheConfiguration;
    @Metadata
    private String cacheConfigurationPropertiesRef;
    @Metadata
    private Map cacheConfigurationProperties;
    @Metadata
    private String configurationUri;

    public JCacheComponent() {
    }

    public JCacheComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String cacheName = remaining;
        JCacheConfiguration configuration = new JCacheConfiguration(this.getCamelContext(), cacheName);
        configuration.setCachingProvider(this.cachingProvider);
        configuration.setCacheConfiguration(this.cacheConfiguration);
        configuration.setCacheConfigurationProperties(this.loadProperties());
        configuration.setConfigurationUri(this.configurationUri);
        JCacheEndpoint endpoint = new JCacheEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    private Properties loadProperties() {
        Properties answer = null;
        if (this.cacheConfigurationProperties != null) {
            answer = new Properties();
            answer.putAll((Map<?, ?>)this.cacheConfigurationProperties);
        }
        if (answer == null && this.cacheConfigurationPropertiesRef != null) {
            Map map = (Map)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.cacheConfigurationPropertiesRef, Map.class);
            answer = new Properties();
            answer.putAll((Map<?, ?>)map);
        }
        return answer;
    }

    public String getCachingProvider() {
        return this.cachingProvider;
    }

    public void setCachingProvider(String cachingProvider) {
        this.cachingProvider = cachingProvider;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public Map getCacheConfigurationProperties() {
        return this.cacheConfigurationProperties;
    }

    public void setCacheConfigurationProperties(Map cacheConfigurationProperties) {
        this.cacheConfigurationProperties = cacheConfigurationProperties;
    }

    public String getCacheConfigurationPropertiesRef() {
        return this.cacheConfigurationPropertiesRef;
    }

    public void setCacheConfigurationPropertiesRef(String cacheConfigurationPropertiesRef) {
        this.cacheConfigurationPropertiesRef = cacheConfigurationPropertiesRef;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }
}

