/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.LRASagaStep;
import org.apache.camel.service.lra.LRAUrlBuilder;

public class LRAClient
implements Closeable {
    private final LRASagaService sagaService;
    private final Client client;
    private final WebTarget target;

    public LRAClient(LRASagaService sagaService) {
        this.sagaService = sagaService;
        this.client = ClientBuilder.newBuilder().build();
        this.target = this.client.target(new LRAUrlBuilder().host(sagaService.getCoordinatorUrl()).path(sagaService.getCoordinatorContextPath()).build());
    }

    public CompletableFuture<URL> newLRA() {
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.target.path("/start").request().async().post(Entity.text((Object)""), this.callbackToCompletableFuture(future));
        return future.thenApply(res -> {
            URL lraURL = this.toURL(res.getHeaders().getFirst((Object)"Long-Running-Action"));
            if (lraURL == null) {
                throw new IllegalStateException("Cannot obtain LRA id from LRA coordinator");
            }
            return lraURL;
        });
    }

    public CompletableFuture<Void> join(URL lra, LRASagaStep step) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LRAUrlBuilder participantBaseUrl = new LRAUrlBuilder().host(this.sagaService.getLocalParticipantUrl()).path(this.sagaService.getLocalParticipantContextPath()).options(step.getOptions()).compensation(step.getCompensation()).completion(step.getCompletion());
            String compensationURL = participantBaseUrl.path("/compensate").build();
            String completionURL = participantBaseUrl.path("/complete").build();
            StringBuilder link = new StringBuilder();
            link.append('<').append(compensationURL).append('>').append("; rel=compensate");
            link.append(',');
            link.append('<').append(completionURL).append('>').append("; rel=complete");
            WebTarget joinTarget = this.client.target(lra.toString());
            if (step.getTimeoutInMilliseconds().isPresent()) {
                joinTarget = joinTarget.queryParam("TimeLimit", new Object[]{step.getTimeoutInMilliseconds().get()});
            }
            CompletableFuture<Response> future = new CompletableFuture<Response>();
            joinTarget.request().header("Link", (Object)link.toString()).header("Long-Running-Action", (Object)lra).async().put(Entity.entity((Object)link.toString(), (String)"text/plain"), this.callbackToCompletableFuture(future));
            return future;
        }, this.sagaService.getExecutorService()).thenCompose(Function.identity())).thenApply(response -> {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeCamelException("Cannot join LRA");
            }
            return null;
        });
    }

    public CompletableFuture<Void> complete(URL lra) {
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.client.target(lra.toString()).path("/close").request().async().put(Entity.entity((Object)"", (String)"text/plain"), this.callbackToCompletableFuture(future));
        return future.thenApply(response -> {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeCamelException("Cannot complete LRA");
            }
            return null;
        });
    }

    public CompletableFuture<Void> compensate(URL lra) {
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.client.target(lra.toString()).path("/cancel").request().async().put(Entity.entity((Object)"", (String)"text/plain"), this.callbackToCompletableFuture(future));
        return future.thenApply(response -> {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeCamelException("Cannot compensate LRA");
            }
            return null;
        });
    }

    private InvocationCallback<Response> callbackToCompletableFuture(final CompletableFuture<Response> future) {
        return new InvocationCallback<Response>(){

            public void completed(Response response) {
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
    }

    private URL toURL(Object url) {
        if (url == null) {
            return null;
        }
        if (url instanceof URL) {
            return (URL)URL.class.cast(url);
        }
        try {
            return new URL(url.toString());
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

