/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.salesforce.NotFoundBehaviour;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalRequest;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class SalesforceEndpointConfig
implements Cloneable {
    public static final String DEFAULT_VERSION = "50.0";
    public static final String API_VERSION = "apiVersion";
    public static final String FORMAT = "format";
    public static final String RAW_PAYLOAD = "rawPayload";
    public static final String SOBJECT_NAME = "sObjectName";
    public static final String SOBJECT_ID = "sObjectId";
    public static final String SOBJECT_FIELDS = "sObjectFields";
    public static final String SOBJECT_EXT_ID_NAME = "sObjectIdName";
    public static final String SOBJECT_EXT_ID_VALUE = "sObjectIdValue";
    public static final String SOBJECT_BLOB_FIELD_NAME = "sObjectBlobFieldName";
    public static final String SOBJECT_CLASS = "sObjectClass";
    public static final String SOBJECT_QUERY = "sObjectQuery";
    public static final String SOBJECT_SEARCH = "sObjectSearch";
    public static final String APEX_METHOD = "apexMethod";
    public static final String APEX_URL = "apexUrl";
    public static final String COMPOSITE_METHOD = "compositeMethod";
    public static final String LIMIT = "limit";
    public static final String APEX_QUERY_PARAM_PREFIX = "apexQueryParam.";
    public static final String CONTENT_TYPE = "contentType";
    public static final String JOB_ID = "jobId";
    public static final String BATCH_ID = "batchId";
    public static final String RESULT_ID = "resultId";
    public static final String REPORT_ID = "reportId";
    public static final String INCLUDE_DETAILS = "includeDetails";
    public static final String REPORT_METADATA = "reportMetadata";
    public static final String INSTANCE_ID = "instanceId";
    public static final String DEFAULT_REPLAY_ID = "defaultReplayId";
    public static final String INITIAL_REPLAY_ID_MAP = "initialReplayIdMap";
    public static final long REPLAY_FROM_TIP = -1L;
    public static final String APPROVAL = "approval";
    public static final int DEFAULT_MAX_AUTHENTICATION_RETRIES = 4;
    public static final long DEFAULT_BACKOFF_INCREMENT = 1000L;
    public static final long DEFAULT_MAX_BACKOFF = 30000L;
    public static final String NOT_FOUND_BEHAVIOUR = "notFoundBehaviour";
    @UriParam(defaultValue="50.0")
    private String apiVersion = "50.0";
    @UriParam
    private PayloadFormat format = PayloadFormat.JSON;
    @UriParam
    private boolean rawPayload;
    @UriParam(displayName="SObject Name")
    private String sObjectName;
    @UriParam(displayName="SObject Id")
    private String sObjectId;
    @UriParam(displayName="SObject Fields")
    private String sObjectFields;
    @UriParam(displayName="SObject Id Name")
    private String sObjectIdName;
    @UriParam(displayName="SObject Id Value")
    private String sObjectIdValue;
    @UriParam(displayName="SObject Blob Field Name")
    private String sObjectBlobFieldName;
    @UriParam(displayName="SObject Class")
    private String sObjectClass;
    @UriParam(displayName="SObject Query")
    private String sObjectQuery;
    @UriParam(displayName="SObject Search")
    private String sObjectSearch;
    @UriParam
    private String apexMethod;
    @UriParam(label="producer")
    private String compositeMethod;
    @UriParam(label="producer")
    private String apexUrl;
    @UriParam
    private Map<String, Object> apexQueryParams;
    @UriParam
    private ContentType contentType;
    @UriParam
    private String jobId;
    @UriParam
    private String batchId;
    @UriParam
    private String resultId;
    @UriParam
    private boolean updateTopic;
    @UriParam
    private NotifyForFieldsEnum notifyForFields;
    @UriParam
    private NotifyForOperationsEnum notifyForOperations;
    @UriParam
    private Boolean notifyForOperationCreate;
    @UriParam
    private Boolean notifyForOperationUpdate;
    @UriParam
    private Boolean notifyForOperationDelete;
    @UriParam
    private Boolean notifyForOperationUndelete;
    @UriParam
    private String reportId;
    @UriParam
    private Boolean includeDetails;
    @UriParam
    private ReportMetadata reportMetadata;
    @UriParam
    private String instanceId;
    @UriParam(description="Default replayId setting if no value is found in initialReplayIdMap", defaultValue="-1")
    private Long defaultReplayId = -1L;
    @UriParam
    private Map<String, Long> initialReplayIdMap;
    private ApprovalRequest approval;
    @UriParam
    private SalesforceHttpClient httpClient;
    @UriParam
    private ObjectMapper objectMapper;
    @UriParam(javaType="java.time.Duration", defaultValue="1000")
    private long backoffIncrement = 1000L;
    @UriParam(javaType="java.time.Duration", defaultValue="30000")
    private long maxBackoff = 30000L;
    @UriParam
    private Integer limit;
    @UriParam(defaultValue="EXCEPTION")
    private NotFoundBehaviour notFoundBehaviour = NotFoundBehaviour.EXCEPTION;

    public SalesforceEndpointConfig copy() {
        try {
            SalesforceEndpointConfig copy = (SalesforceEndpointConfig)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    public PayloadFormat getFormat() {
        return this.format;
    }

    public void setFormat(PayloadFormat format) {
        this.format = format;
    }

    public boolean isRawPayload() {
        return this.rawPayload;
    }

    public void setRawPayload(boolean rawPayload) {
        this.rawPayload = rawPayload;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getSObjectName() {
        return this.sObjectName;
    }

    public void setSObjectName(String sObjectName) {
        this.sObjectName = sObjectName;
    }

    public String getSObjectId() {
        return this.sObjectId;
    }

    public void setSObjectId(String sObjectId) {
        this.sObjectId = sObjectId;
    }

    public String getSObjectFields() {
        return this.sObjectFields;
    }

    public void setSObjectFields(String sObjectFields) {
        this.sObjectFields = sObjectFields;
    }

    public String getSObjectIdName() {
        return this.sObjectIdName;
    }

    public void setSObjectIdName(String sObjectIdName) {
        this.sObjectIdName = sObjectIdName;
    }

    public String getSObjectIdValue() {
        return this.sObjectIdValue;
    }

    public void setSObjectIdValue(String sObjectIdValue) {
        this.sObjectIdValue = sObjectIdValue;
    }

    public String getSObjectBlobFieldName() {
        return this.sObjectBlobFieldName;
    }

    public void setSObjectBlobFieldName(String sObjectBlobFieldName) {
        this.sObjectBlobFieldName = sObjectBlobFieldName;
    }

    public String getSObjectClass() {
        return this.sObjectClass;
    }

    public void setSObjectClass(String sObjectClass) {
        this.sObjectClass = sObjectClass;
    }

    public String getSObjectQuery() {
        return this.sObjectQuery;
    }

    public void setSObjectQuery(String sObjectQuery) {
        this.sObjectQuery = sObjectQuery;
    }

    public String getSObjectSearch() {
        return this.sObjectSearch;
    }

    public void setSObjectSearch(String sObjectSearch) {
        this.sObjectSearch = sObjectSearch;
    }

    public String getApexMethod() {
        return this.apexMethod;
    }

    public void setApexMethod(String apexMethod) {
        this.apexMethod = apexMethod;
    }

    public String getApexUrl() {
        return this.apexUrl;
    }

    public void setApexUrl(String apexUrl) {
        this.apexUrl = apexUrl;
    }

    public Map<String, Object> getApexQueryParams() {
        Map value = Optional.ofNullable(this.apexQueryParams).orElse(Collections.emptyMap());
        return Collections.unmodifiableMap(value);
    }

    public void setApexQueryParams(Map<String, Object> apexQueryParams) {
        this.apexQueryParams = apexQueryParams;
    }

    public String getCompositeMethod() {
        return this.compositeMethod;
    }

    public void setCompositeMethod(String compositeMethod) {
        this.compositeMethod = compositeMethod;
    }

    public ApprovalRequest getApproval() {
        return this.approval;
    }

    public void setApproval(ApprovalRequest approval) {
        this.approval = approval;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getResultId() {
        return this.resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    public boolean isUpdateTopic() {
        return this.updateTopic;
    }

    public void setUpdateTopic(boolean updateTopic) {
        this.updateTopic = updateTopic;
    }

    public NotifyForFieldsEnum getNotifyForFields() {
        return this.notifyForFields;
    }

    public void setNotifyForFields(NotifyForFieldsEnum notifyForFields) {
        this.notifyForFields = notifyForFields;
    }

    public NotifyForOperationsEnum getNotifyForOperations() {
        return this.notifyForOperations;
    }

    public void setNotifyForOperations(NotifyForOperationsEnum notifyForOperations) {
        this.notifyForOperations = notifyForOperations;
    }

    public Boolean getNotifyForOperationCreate() {
        return this.notifyForOperationCreate;
    }

    public void setNotifyForOperationCreate(Boolean notifyForOperationCreate) {
        this.notifyForOperationCreate = notifyForOperationCreate;
    }

    public Boolean getNotifyForOperationUpdate() {
        return this.notifyForOperationUpdate;
    }

    public void setNotifyForOperationUpdate(Boolean notifyForOperationUpdate) {
        this.notifyForOperationUpdate = notifyForOperationUpdate;
    }

    public Boolean getNotifyForOperationDelete() {
        return this.notifyForOperationDelete;
    }

    public void setNotifyForOperationDelete(Boolean notifyForOperationDelete) {
        this.notifyForOperationDelete = notifyForOperationDelete;
    }

    public Boolean getNotifyForOperationUndelete() {
        return this.notifyForOperationUndelete;
    }

    public void setNotifyForOperationUndelete(Boolean notifyForOperationUndelete) {
        this.notifyForOperationUndelete = notifyForOperationUndelete;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Boolean getIncludeDetails() {
        return this.includeDetails;
    }

    public void setIncludeDetails(Boolean includeDetails) {
        this.includeDetails = includeDetails;
    }

    public ReportMetadata getReportMetadata() {
        return this.reportMetadata;
    }

    public void setReportMetadata(ReportMetadata reportMetadata) {
        this.reportMetadata = reportMetadata;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setHttpClient(SalesforceHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public SalesforceHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public void setBackoffIncrement(long backoffIncrement) {
        this.backoffIncrement = backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public void setMaxBackoff(long maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Map<String, Object> toValueMap() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(FORMAT, this.format.toString().toLowerCase());
        valueMap.put(API_VERSION, this.apiVersion);
        valueMap.put(SOBJECT_NAME, this.sObjectName);
        valueMap.put(SOBJECT_ID, this.sObjectId);
        valueMap.put(SOBJECT_FIELDS, this.sObjectFields);
        valueMap.put(SOBJECT_EXT_ID_NAME, this.sObjectIdName);
        valueMap.put(SOBJECT_BLOB_FIELD_NAME, this.sObjectBlobFieldName);
        valueMap.put(SOBJECT_EXT_ID_VALUE, this.sObjectIdValue);
        valueMap.put(SOBJECT_CLASS, this.sObjectClass);
        valueMap.put(SOBJECT_QUERY, this.sObjectQuery);
        valueMap.put(SOBJECT_SEARCH, this.sObjectSearch);
        valueMap.put(APEX_METHOD, this.apexMethod);
        valueMap.put(APEX_URL, this.apexUrl);
        valueMap.put(COMPOSITE_METHOD, this.compositeMethod);
        valueMap.put(LIMIT, this.limit);
        valueMap.put(APPROVAL, this.approval);
        if (this.contentType != null) {
            valueMap.put(CONTENT_TYPE, this.contentType.value());
        }
        valueMap.put(JOB_ID, this.jobId);
        valueMap.put(BATCH_ID, this.batchId);
        valueMap.put(RESULT_ID, this.resultId);
        valueMap.put(REPORT_ID, this.reportId);
        valueMap.put(INCLUDE_DETAILS, this.includeDetails);
        valueMap.put(REPORT_METADATA, this.reportMetadata);
        valueMap.put(INSTANCE_ID, this.instanceId);
        valueMap.put(DEFAULT_REPLAY_ID, this.defaultReplayId);
        valueMap.put(INITIAL_REPLAY_ID_MAP, this.initialReplayIdMap);
        valueMap.put(NOT_FOUND_BEHAVIOUR, (Object)this.notFoundBehaviour);
        return Collections.unmodifiableMap(valueMap);
    }

    public Long getDefaultReplayId() {
        return this.defaultReplayId;
    }

    public void setDefaultReplayId(Long defaultReplayId) {
        this.defaultReplayId = defaultReplayId;
    }

    public Map<String, Long> getInitialReplayIdMap() {
        return Optional.ofNullable(this.initialReplayIdMap).orElse(Collections.emptyMap());
    }

    public void setInitialReplayIdMap(Map<String, Long> initialReplayIdMap) {
        this.initialReplayIdMap = initialReplayIdMap;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ApprovalRequest.Action getApprovalActionType() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getActionType();
    }

    public String getApprovalComments() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getComments();
    }

    public String getApprovalContextActorId() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getContextActorId();
    }

    public String getApprovalContextId() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getContextId();
    }

    public List<String> getApprovalNextApproverIds() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getNextApproverIds();
    }

    public String getApprovalProcessDefinitionNameOrId() {
        if (this.approval == null) {
            return null;
        }
        return this.approval.getProcessDefinitionNameOrId();
    }

    public boolean isApprovalSkipEntryCriteria() {
        if (this.approval == null) {
            return false;
        }
        return this.approval.isSkipEntryCriteria();
    }

    public void setApprovalActionType(ApprovalRequest.Action actionType) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setActionType(actionType);
    }

    public void setApprovalComments(String comments) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setComments(comments);
    }

    public void setApprovalContextActorId(String contextActorId) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setContextActorId(contextActorId);
    }

    public void setApprovalContextId(String contextId) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setContextId(contextId);
    }

    public void setApprovalNextApproverIds(List<String> nextApproverIds) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setNextApproverIds(nextApproverIds);
    }

    public void setApprovalNextApproverIds(String nextApproverId) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setNextApproverIds(nextApproverId);
    }

    public void setApprovalProcessDefinitionNameOrId(String processDefinitionNameOrId) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setProcessDefinitionNameOrId(processDefinitionNameOrId);
    }

    public void setApprovalSkipEntryCriteria(boolean skipEntryCriteria) {
        if (this.approval == null) {
            this.approval = new ApprovalRequest();
        }
        this.approval.setSkipEntryCriteria(skipEntryCriteria);
    }

    public NotFoundBehaviour getNotFoundBehaviour() {
        return this.notFoundBehaviour;
    }

    public void setNotFoundBehaviour(NotFoundBehaviour notFoundBehaviour) {
        this.notFoundBehaviour = notFoundBehaviour;
    }
}

