/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.URISupport;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.chat2.IncomingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppConsumer
extends DefaultConsumer
implements IncomingChatMessageListener,
MessageListener,
StanzaListener {
    private static final Logger LOG = LoggerFactory.getLogger(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private MultiUserChat muc;
    private Chat privateChat;
    private ChatManager chatManager;
    private XMPPTCPConnection connection;
    private ScheduledExecutorService scheduledExecutor;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        try {
            this.connection = this.endpoint.createConnection();
        }
        catch (SmackException e) {
            if (this.endpoint.isTestConnectionOnStartup()) {
                throw new RuntimeException("Could not connect to XMPP server.", e);
            }
            LOG.warn(e.getMessage());
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(e.getMessage(), (Throwable)e);
            }
            this.scheduleDelayedStart();
            return;
        }
        this.chatManager = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        this.chatManager.addIncomingListener((IncomingChatMessageListener)this);
        OrFilter pubsubPacketFilter = new OrFilter();
        if (this.endpoint.isPubsub()) {
            pubsubPacketFilter.addFilter(MessageTypeFilter.HEADLINE);
            pubsubPacketFilter.addFilter(MessageTypeFilter.NORMAL);
            this.connection.addSyncStanzaListener((StanzaListener)this, (StanzaFilter)pubsubPacketFilter);
        }
        if (this.endpoint.getRoom() == null) {
            this.privateChat = this.chatManager.chatWith(JidCreate.entityBareFrom((String)this.endpoint.resolveParticipant((XMPPConnection)this.connection)));
        } else {
            AndFilter packetFilter = new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Presence.class)});
            this.connection.addSyncStanzaListener((StanzaListener)this, (StanzaFilter)packetFilter);
            String roomPassword = this.endpoint.getRoomPassword();
            MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection);
            this.muc = mucm.getMultiUserChat(JidCreate.entityBareFrom((String)this.endpoint.resolveRoom((XMPPConnection)this.connection)));
            this.muc.addMessageListener((MessageListener)this);
            MucEnterConfiguration.Builder mucc = this.muc.getEnterConfigurationBuilder(Resourcepart.from((String)this.endpoint.getNickname())).requestNoHistory();
            if (roomPassword != null) {
                mucc.withPassword(roomPassword);
            }
            this.muc.join(mucc.build());
            LOG.info("Joined room: {} as: {}", (Object)this.muc.getRoom(), (Object)this.endpoint.getNickname());
        }
        this.startRobustConnectionMonitor();
        super.doStart();
    }

    protected void scheduleDelayedStart() throws Exception {
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    XmppConsumer.this.doStart();
                }
                catch (Exception e) {
                    LOG.warn("Ignoring an exception caught in the startup connection poller thread.", (Throwable)e);
                }
            }
        };
        LOG.info("Delaying XMPP consumer startup for endpoint {}. Trying again in {} seconds.", (Object)URISupport.sanitizeUri((String)this.endpoint.getEndpointUri()), (Object)this.endpoint.getConnectionPollDelay());
        this.getExecutor().schedule(startRunnable, (long)this.endpoint.getConnectionPollDelay(), TimeUnit.SECONDS);
    }

    private void startRobustConnectionMonitor() throws Exception {
        Runnable connectionCheckRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    XmppConsumer.this.checkConnection();
                }
                catch (Exception e) {
                    LOG.warn("Ignoring an exception caught in the connection poller thread.", (Throwable)e);
                }
            }
        };
        this.getExecutor().scheduleAtFixedRate(connectionCheckRunnable, this.endpoint.getConnectionPollDelay(), this.endpoint.getConnectionPollDelay(), TimeUnit.SECONDS);
    }

    private void checkConnection() throws Exception {
        if (!this.connection.isConnected()) {
            LOG.info("Attempting to reconnect to: {}", (Object)XmppEndpoint.getConnectionMessage((XMPPConnection)this.connection));
            try {
                this.connection.connect();
                LOG.debug("Successfully connected to XMPP server through: {}", (Object)this.connection);
            }
            catch (SmackException e) {
                LOG.warn("Connection to XMPP server failed. Will try to reconnect later again.", (Throwable)e);
            }
        }
    }

    private ScheduledExecutorService getExecutor() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "connectionPoll");
        }
        return this.scheduledExecutor;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
        if (this.muc != null) {
            LOG.info("Leaving room: {}", (Object)this.muc.getRoom());
            this.muc.removeMessageListener((MessageListener)this);
            this.muc.leave();
            this.muc = null;
        }
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    public void newIncomingMessage(EntityBareJid from, Message message, Chat chat) {
        this.processMessage(message);
    }

    public void processMessage(Message message) {
        this.processMessage(null, message);
    }

    public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
        if (stanza instanceof Message) {
            this.processMessage((Message)stanza);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Chat chat, Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received XMPP message for {} from {} : {}", new Object[]{this.endpoint.getUser(), this.endpoint.getParticipant(), message.getBody()});
        }
        Exchange exchange = this.endpoint.createExchange((Stanza)message);
        if (this.endpoint.isDoc()) {
            exchange.getIn().setHeader("CamelXmppDoc", (Object)message);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            if (this.muc != null) {
                try {
                    this.muc.pollMessage();
                }
                catch (MultiUserChatException.MucNotJoinedException e) {
                    LOG.debug("Error while polling message from MultiUserChat. This exception will be ignored.", (Throwable)e);
                }
            }
        }
    }
}

