/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerAbstract;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsInvalidKeyException;
import org.apache.camel.component.crypto.cms.sig.SignedDataCreatorConfiguration;
import org.apache.camel.component.crypto.cms.sig.SignerInfo;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDataCreator
extends CryptoCmsMarshallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDataCreator.class);
    private SignedDataCreatorConfiguration config;

    public SignedDataCreator(SignedDataCreatorConfiguration conf) {
        super(conf);
        this.config = conf;
    }

    @Override
    protected void setBodyAndHeader(Message out, Object encodedSignedData) {
        if (this.config.getIncludeContent().booleanValue()) {
            out.setBody(encodedSignedData);
        } else {
            out.setHeader("CamelCryptoCmsSignedData", encodedSignedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void marshalInternal(InputStream is, OutputStream os, Exchange exchange) throws Exception {
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        if (this.config.getSignerList().isEmpty()) {
            throw new CryptoCmsException("No signer information configured");
        }
        for (SignerInfo signer : this.config.getSignerList()) {
            ContentSigner contentSigner;
            LOG.debug("Signer info: {}", (Object)signer);
            X509Certificate signerCert = signer.getCertificate(exchange);
            if (signerCert == null) {
                throw new CryptoCmsException("Certificate missing in the singer information " + signer);
            }
            PrivateKey key = signer.getPrivateKey(exchange);
            if (key == null) {
                throw new CryptoCmsException("Private key missing in the singer information " + signer);
            }
            try {
                contentSigner = new JcaContentSignerBuilder(signer.getSignatureAlgorithm(exchange)).setProvider("BC").build(key);
            }
            catch (OperatorCreationException e) {
                throw new CryptoCmsInvalidKeyException("The private key of the signer information  '" + signer + "' does not fit to the specified signature algorithm '" + signer.getSignatureAlgorithm(exchange) + "': " + e.getMessage(), e);
            }
            JcaSignerInfoGeneratorBuilder signerBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            signerBuilder.setSignedAttributeGenerator(signer.getSignedAttributeGenerator(exchange)).setUnsignedAttributeGenerator(signer.getUnsignedAttributeGenerator(exchange));
            gen.addSignerInfoGenerator(signerBuilder.build(contentSigner, signerCert));
            ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
            for (Certificate cert : signer.getCertificateChain(exchange)) {
                if (certificateList.contains(cert)) continue;
                certificateList.add(cert);
                gen.addCertificate(new X509CertificateHolder(cert.getEncoded()));
                LOG.debug("Certificate added to Signed Data certificate list: {}", (Object)cert);
            }
        }
        OutputStream sigOut = gen.open(os, this.config.getIncludeContent().booleanValue());
        try {
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)sigOut);
        }
        finally {
            IOHelper.close((Closeable)sigOut);
        }
        LOG.debug("CMS Signed Data generation successful");
    }
}

