/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.tika.TikaConfiguration;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.component.tika.TikaOperation;
import org.apache.camel.component.tika.TikaParseOutputFormat;
import org.apache.camel.support.DefaultProducer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.BoilerpipeContentHandler;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaProducer
extends DefaultProducer {
    private final TikaConfiguration tikaConfiguration;
    private final Parser parser;
    private final Detector detector;
    private final String encoding;

    public TikaProducer(TikaEndpoint endpoint) {
        this(endpoint, null);
    }

    public TikaProducer(TikaEndpoint endpoint, Parser parser) {
        super((Endpoint)endpoint);
        this.tikaConfiguration = endpoint.getTikaConfiguration();
        this.encoding = this.tikaConfiguration.getTikaParseOutputEncoding();
        TikaConfig config = this.tikaConfiguration.getTikaConfig();
        this.detector = config.getDetector();
        this.parser = parser == null ? new AutoDetectParser(this.tikaConfiguration.getTikaConfig()) : parser;
    }

    public void process(Exchange exchange) throws Exception {
        Object result;
        TikaOperation operation = this.tikaConfiguration.getOperation();
        switch (operation) {
            case detect: {
                result = this.doDetect(exchange);
                break;
            }
            case parse: {
                result = this.doParse(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operation %s", new Object[]{this.tikaConfiguration.getOperation()}));
            }
        }
        exchange.getMessage().setHeaders(exchange.getIn().getHeaders());
        exchange.getMessage().setBody(result);
    }

    private Object doDetect(Exchange exchange) throws IOException {
        MediaType result;
        try (InputStream inputStream = (InputStream)exchange.getIn().getBody(InputStream.class);){
            Metadata metadata = new Metadata();
            result = this.detector.detect(inputStream, metadata);
            this.convertMetadataToHeaders(metadata, exchange);
        }
        return result.toString();
    }

    private Object doParse(Exchange exchange) throws TikaException, IOException, SAXException, TransformerConfigurationException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (InputStream inputStream = (InputStream)exchange.getIn().getBody(InputStream.class);){
            ContentHandler contentHandler = this.getContentHandler(this.tikaConfiguration, result);
            ParseContext context = new ParseContext();
            context.set(Parser.class, (Object)this.parser);
            Metadata metadata = new Metadata();
            this.parser.parse(inputStream, contentHandler, metadata, context);
            this.convertMetadataToHeaders(metadata, exchange);
        }
        return result;
    }

    private void convertMetadataToHeaders(Metadata metadata, Exchange exchange) {
        if (metadata != null) {
            for (String metaname : metadata.names()) {
                String[] values = metadata.getValues(metaname);
                if (values.length == 1) {
                    exchange.getIn().setHeader(metaname, (Object)values[0]);
                    continue;
                }
                exchange.getIn().setHeader(metaname, (Object)values);
            }
        }
    }

    private ContentHandler getContentHandler(TikaConfiguration configuration, OutputStream outputStream) throws TransformerConfigurationException, UnsupportedEncodingException {
        TransformerHandler result = null;
        TikaParseOutputFormat outputFormat = configuration.getTikaParseOutputFormat();
        switch (outputFormat) {
            case xml: {
                result = this.getTransformerHandler(outputStream, "xml", true);
                break;
            }
            case text: {
                result = new BodyContentHandler((Writer)new OutputStreamWriter(outputStream, this.encoding));
                break;
            }
            case textMain: {
                result = new BoilerpipeContentHandler((Writer)new OutputStreamWriter(outputStream, this.encoding));
                break;
            }
            case html: {
                result = new ExpandedTitleContentHandler((ContentHandler)this.getTransformerHandler(outputStream, "html", true));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown format %s", new Object[]{this.tikaConfiguration.getTikaParseOutputFormat()}));
            }
        }
        return result;
    }

    private TransformerHandler getTransformerHandler(OutputStream output, String method, boolean prettyPrint) throws TransformerConfigurationException, UnsupportedEncodingException {
        SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", method);
        handler.getTransformer().setOutputProperty("indent", prettyPrint ? "yes" : "no");
        if (this.encoding != null) {
            handler.getTransformer().setOutputProperty("encoding", this.encoding);
        }
        handler.setResult(new StreamResult(new OutputStreamWriter(output, this.encoding)));
        return handler;
    }
}

