/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis.processor.idempotent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.redis.processor.idempotent.RedisIdempotentRepository;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ValueOperations;

@ManagedResource(description="Spring Redis based message id repository")
public class RedisStringIdempotentRepository
extends RedisIdempotentRepository {
    private final ValueOperations<String, String> valueOperations;
    private long expiry;

    public RedisStringIdempotentRepository(RedisTemplate<String, String> redisTemplate, String processorName) {
        super(redisTemplate, processorName);
        this.valueOperations = redisTemplate.opsForValue();
    }

    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        String value = (String)this.valueOperations.get((Object)this.createRedisKey(key));
        return value != null;
    }

    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (this.expiry > 0L) {
            return this.valueOperations.setIfAbsent((Object)this.createRedisKey(key), (Object)key, Duration.ofSeconds(this.expiry));
        }
        return this.valueOperations.setIfAbsent((Object)this.createRedisKey(key), (Object)key);
    }

    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.valueOperations.getOperations().delete((Object)this.createRedisKey(key));
        return true;
    }

    @Override
    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.valueOperations.getOperations().execute((RedisCallback)new RedisCallback<List<byte[]>>(){

            public List<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                ArrayList<byte[]> binaryKeys = new ArrayList<byte[]>();
                Cursor cursor = connection.scan(ScanOptions.scanOptions().match("*" + RedisStringIdempotentRepository.this.createRedisKey("*")).build());
                while (cursor.hasNext()) {
                    byte[] key = (byte[])cursor.next();
                    binaryKeys.add(key);
                }
                if (!binaryKeys.isEmpty()) {
                    connection.del((byte[][])binaryKeys.toArray((T[])new byte[0][]));
                }
                return binaryKeys;
            }
        });
    }

    protected String createRedisKey(String key) {
        return this.getProcessorName() + ":" + key;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }
}

