/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.component.olingo2.Olingo2Endpoint;
import org.apache.camel.component.olingo2.Olingo2Index;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.camel.component.olingo2.internal.Olingo2ApiName;
import org.apache.camel.component.olingo2.internal.Olingo2PropertiesHelper;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.AbstractApiProducer;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Olingo2Producer
extends AbstractApiProducer<Olingo2ApiName, Olingo2Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(Olingo2Producer.class);
    private static final String RESPONSE_HTTP_HEADERS = "responseHttpHeaders";
    private Olingo2Index resultIndex;

    public Olingo2Producer(Olingo2Endpoint endpoint) {
        super((AbstractApiEndpoint)endpoint, (ApiMethodPropertiesHelper)Olingo2PropertiesHelper.getHelper(endpoint.getCamelContext()));
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(this.endpoint.getEndpointProperties());
        this.propertiesHelper.getExchangeProperties(exchange, properties);
        this.endpoint.interceptProperties(properties);
        this.interceptProperties(properties);
        properties.put("responseHandler", new Olingo2ResponseHandler<Object>(){

            public void onResponse(Object response, Map<String, String> responseHeaders) {
                if (Olingo2Producer.this.resultIndex != null) {
                    response = Olingo2Producer.this.resultIndex.filterResponse(response);
                }
                exchange.getOut().setBody(response);
                exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                exchange.getOut().setHeader("CamelOlingo2.responseHttpHeaders", responseHeaders);
                Olingo2Producer.this.interceptResult(response, exchange);
                callback.done(false);
            }

            public void onException(Exception ex) {
                exchange.setException((Throwable)ex);
                callback.done(false);
            }

            public void onCanceled() {
                exchange.setException((Throwable)new RuntimeCamelException("OData HTTP Request cancelled!"));
                callback.done(false);
            }
        });
        ApiMethod method = this.findMethod(exchange, properties);
        if (method == null) {
            callback.done(true);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking operation {} with {}", (Object)method.getName(), properties.keySet());
        }
        try {
            this.doInvokeMethod(method, properties);
        }
        catch (Throwable t) {
            exchange.setException((Throwable)RuntimeCamelException.wrapRuntimeCamelException((Throwable)t));
            callback.done(true);
            return true;
        }
        return false;
    }

    public void interceptProperties(Map<String, Object> properties) {
        Object value = properties.get("filterAlreadySeen");
        if (value == null) {
            return;
        }
        if (Boolean.parseBoolean(value.toString()) && this.resultIndex == null) {
            this.resultIndex = new Olingo2Index();
        }
    }

    public void interceptResult(Object result, Exchange resultExchange) {
        if (this.resultIndex == null) {
            return;
        }
        this.resultIndex.index(result);
    }
}

