/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.thrift;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.io.IOUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;

@Dataformat(value="thrift")
public class ThriftDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    public static final String CONTENT_TYPE_FORMAT_BINARY = "binary";
    public static final String CONTENT_TYPE_FORMAT_JSON = "json";
    public static final String CONTENT_TYPE_FORMAT_SIMPLE_JSON = "sjson";
    private static final String CONTENT_TYPE_HEADER_NATIVE = "application/octet-stream";
    private static final String CONTENT_TYPE_HEADER_JSON = "application/json";
    private CamelContext camelContext;
    private TBase defaultInstance;
    private String instanceClassName;
    private boolean contentTypeHeader = true;
    private String contentTypeFormat = "binary";

    public ThriftDataFormat() {
    }

    public ThriftDataFormat(TBase defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public ThriftDataFormat(TBase defaultInstance, String contentTypeFormat) {
        this.defaultInstance = defaultInstance;
        this.contentTypeFormat = contentTypeFormat;
    }

    public String getDataFormatName() {
        return "thrift";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setDefaultInstance(TBase instance) {
        this.defaultInstance = instance;
    }

    public void setDefaultInstance(Object instance) {
        if (!(instance instanceof TBase)) {
            throw new IllegalArgumentException("The argument for setDefaultInstance should be subClass of org.apache.thrift.TBase");
        }
        this.defaultInstance = (TBase)instance;
    }

    public void setInstanceClass(String className) throws Exception {
        ObjectHelper.notNull((Object)className, (String)"ThriftDataFormat instaceClass");
        this.instanceClassName = className;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeFormat(String contentTypeFormat) {
        StringHelper.notEmpty((String)contentTypeFormat, (String)"ThriftDataFormat contentTypeFormat");
        this.contentTypeFormat = contentTypeFormat;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        String contentTypeHeader = CONTENT_TYPE_HEADER_NATIVE;
        if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_JSON)) {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
            IOUtils.write((String)serializer.toString((TBase)graph, "UTF-8"), (OutputStream)outputStream, (String)"UTF-8");
            contentTypeHeader = CONTENT_TYPE_HEADER_JSON;
        } else if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_SIMPLE_JSON)) {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TSimpleJSONProtocol.Factory());
            IOUtils.write((String)serializer.toString((TBase)graph, "UTF-8"), (OutputStream)outputStream, (String)"UTF-8");
            contentTypeHeader = CONTENT_TYPE_HEADER_JSON;
        } else if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_BINARY)) {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            IOUtils.write((byte[])serializer.serialize((TBase)graph), (OutputStream)outputStream);
        } else {
            throw new CamelException("Invalid thrift content type format: " + this.contentTypeFormat);
        }
        if (this.isContentTypeHeader()) {
            exchange.getMessage().setHeader("Content-Type", (Object)contentTypeHeader);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        ObjectHelper.notNull((Object)this.defaultInstance, (String)"defaultInstance or instanceClassName must be set", (Object)((Object)this));
        if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_JSON)) {
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
            deserializer.deserialize(this.defaultInstance, IOUtils.toByteArray((InputStream)inputStream));
        } else if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_BINARY)) {
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize(this.defaultInstance, IOUtils.toByteArray((InputStream)inputStream));
        } else {
            if (this.contentTypeFormat.equals(CONTENT_TYPE_FORMAT_SIMPLE_JSON)) {
                throw new CamelException("Simple JSON format is avalable for the message marshalling only");
            }
            throw new CamelException("Invalid thrift content type format: " + this.contentTypeFormat);
        }
        return this.defaultInstance;
    }

    protected TBase loadDefaultInstance(String className, CamelContext context) throws CamelException, ClassNotFoundException {
        Class instanceClass = context.getClassResolver().resolveMandatoryClass(className);
        if (TBase.class.isAssignableFrom(instanceClass)) {
            try {
                return (TBase)instanceClass.newInstance();
            }
            catch (Exception ex) {
                throw new CamelException("Can't set the defaultInstance of ThriftDataFormat with " + className + ", caused by " + ex);
            }
        }
        throw new CamelException("Can't set the defaultInstance of ThriftDataFormat with " + className + ", as the class is not a subClass of org.apache.thrift.TBase");
    }

    protected void doStart() throws Exception {
        if (this.defaultInstance == null && this.instanceClassName != null) {
            this.defaultInstance = this.loadDefaultInstance(this.instanceClassName, this.getCamelContext());
        }
    }

    protected void doStop() throws Exception {
    }
}

