/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.corda;

import net.corda.client.rpc.CordaRPCClient;
import net.corda.client.rpc.CordaRPCConnection;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.utilities.NetworkHostAndPort;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.corda.CordaComponent;
import org.apache.camel.component.corda.CordaConfiguration;
import org.apache.camel.component.corda.CordaConsumer;
import org.apache.camel.component.corda.CordaProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="corda", title="Corda", syntax="corda:node", category={Category.BLOCKCHAIN, Category.RPC})
public class CordaEndpoint
extends DefaultEndpoint {
    @UriParam
    private CordaConfiguration configuration;
    private CordaRPCConnection rpcConnection;
    private CordaRPCOps proxy;

    public CordaEndpoint(String uri, CordaComponent component, CordaConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CordaProducer(this, this.configuration, this.proxy);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CordaConsumer consumer = new CordaConsumer(this, processor, this.configuration, this.proxy);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public CordaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CordaConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        NetworkHostAndPort rpcAddress = new NetworkHostAndPort(this.configuration.retrieveHost(), this.configuration.retrievePort());
        CordaRPCClient rpcClient = new CordaRPCClient(rpcAddress);
        this.rpcConnection = rpcClient.start(this.configuration.getUsername(), this.configuration.getPassword());
        this.proxy = this.rpcConnection.getProxy();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.rpcConnection != null) {
            this.rpcConnection.notifyServerAndClose();
        }
        super.doStop();
    }
}

