/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron;

import java.util.HashMap;
import javax.xml.transform.Source;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.schematron.SchematronEndpoint;
import org.apache.camel.component.schematron.exception.SchematronValidationException;
import org.apache.camel.component.schematron.processor.SchematronProcessor;
import org.apache.camel.component.schematron.processor.SchematronProcessorFactory;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SchematronProducer.class);
    private SchematronEndpoint endpoint;

    public SchematronProducer(SchematronEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String report;
        SchematronProcessor schematronProcessor = SchematronProcessorFactory.newSchematronEngine(this.endpoint.getRules());
        Object payload = exchange.getIn().getBody();
        if (payload instanceof Source) {
            LOG.debug("Applying schematron validation on payload: {}", payload);
            report = schematronProcessor.validate((Source)payload);
        } else if (payload instanceof String) {
            LOG.debug("Applying schematron validation on payload: {}", payload);
            report = schematronProcessor.validate((String)payload);
        } else {
            String stringPayload = (String)exchange.getIn().getBody(String.class);
            LOG.debug("Applying schematron validation on payload: {}", (Object)stringPayload);
            report = schematronProcessor.validate(stringPayload);
        }
        LOG.debug("Schematron validation report \n {}", (Object)report);
        String status = this.getValidationStatus(report);
        LOG.info("Schematron validation status : {}", (Object)status);
        this.setValidationReport(exchange, report, status);
    }

    private void setValidationReport(Exchange exchange, String report, String status) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelSchematronValidationStatus", status);
        headers.put("CamelSchematronValidationReport", report);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().getHeaders().putAll(headers);
        } else {
            exchange.getIn().getHeaders().putAll(headers);
        }
    }

    private String getValidationStatus(String report) {
        String status;
        String string = status = report.contains("failed-assert") ? "FAILED" : "SUCCESS";
        if (this.endpoint.isAbort() && "FAILED".equals(status)) {
            throw new SchematronValidationException("Schematron validation failure \n" + report);
        }
        return status;
    }
}

