/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.kinesis.Kinesis2ComponentVerifierExtension;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws2-kinesis")
public class Kinesis2Component
extends DefaultComponent {
    @Metadata
    private Kinesis2Configuration configuration = new Kinesis2Configuration();

    public Kinesis2Component() {
        this(null);
    }

    public Kinesis2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Kinesis2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Kinesis2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Kinesis2Configuration();
        configuration.setStreamName(remaining);
        Kinesis2Endpoint endpoint = new Kinesis2Endpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getAmazonKinesisClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonKinesisClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Kinesis2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Kinesis2Configuration configuration) {
        this.configuration = configuration;
    }
}

