/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.eventbridge.EventbridgeComponentVerifierExtension;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-eventbridge")
public class EventbridgeComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(EventbridgeComponent.class);
    @Metadata
    private EventbridgeConfiguration configuration = new EventbridgeConfiguration();

    public EventbridgeComponent() {
        this(null);
    }

    public EventbridgeComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new EventbridgeComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Event bus name must be specified.");
        }
        EventbridgeConfiguration configuration = this.configuration != null ? this.configuration.copy() : new EventbridgeConfiguration();
        configuration.setEventbusName(remaining);
        EventbridgeEndpoint endpoint = new EventbridgeEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getEventbridgeClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon Eventbridge client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public EventbridgeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EventbridgeConfiguration configuration) {
        this.configuration = configuration;
    }
}

