/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CamelNodeDetails {
    private String fileName;
    private String lineNumber;
    private String lineNumberEnd;
    private int linePosition;
    private String className;
    private String methodName;
    private final CamelNodeDetails parent;
    private final String name;
    private final int order;
    private List<CamelNodeDetails> outputs;
    private String routeId;

    public CamelNodeDetails(CamelNodeDetails parent, String name, int order, CamelNodeDetails copy) {
        this.parent = parent;
        this.name = name;
        this.order = order;
        this.routeId = copy.getRouteId();
        this.fileName = copy.getFileName();
        this.lineNumber = copy.getLineNumber();
        this.lineNumberEnd = copy.getLineNumberEnd();
        this.className = copy.getClassName();
        this.methodName = copy.getMethodName();
    }

    public CamelNodeDetails(CamelNodeDetails parent, String name, int order) {
        this.parent = parent;
        this.name = name;
        this.order = order;
    }

    public void addPreliminaryOutput(CamelNodeDetails output) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<CamelNodeDetails>();
        }
        this.outputs.add(0, output);
    }

    public void addOutput(CamelNodeDetails output) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<CamelNodeDetails>();
        }
        this.outputs.add(output);
    }

    public CamelNodeDetails getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public List<CamelNodeDetails> getOutputs() {
        if (this.outputs == null) {
            return Collections.emptyList();
        }
        return this.outputs;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getLineNumberEnd() {
        return this.lineNumberEnd;
    }

    public void setLineNumberEnd(String lineNumberEnd) {
        this.lineNumberEnd = lineNumberEnd;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String toString() {
        return this.name;
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lineNumber);
        sb.append("\t");
        sb.append(CamelNodeDetails.padString(level));
        sb.append(this.name);
        if (this.outputs != null) {
            ++level;
            for (CamelNodeDetails child : this.outputs) {
                String text = child.dump(level);
                sb.append("\n");
                sb.append(text);
            }
        }
        return sb.toString();
    }

    private static String padString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

