/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Resilience Processor")
public class ResilienceProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ResilienceProcessor.class);
    private volatile CircuitBreaker circuitBreaker;
    private CamelContext camelContext;
    private String id;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final BulkheadConfig bulkheadConfig;
    private final TimeLimiterConfig timeLimiterConfig;
    private final Processor processor;
    private final Processor fallback;
    private boolean shutdownExecutorService;
    private ExecutorService executorService;

    public ResilienceProcessor(CircuitBreakerConfig circuitBreakerConfig, BulkheadConfig bulkheadConfig, TimeLimiterConfig timeLimiterConfig, Processor processor, Processor fallback) {
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.bulkheadConfig = bulkheadConfig;
        this.timeLimiterConfig = timeLimiterConfig;
        this.processor = processor;
        this.fallback = fallback;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getTraceLabel() {
        return "resilience4j";
    }

    @ManagedAttribute(description="Returns the current failure rate in percentage.")
    public float getFailureRate() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getFailureRate();
        }
        return 0.0f;
    }

    @ManagedAttribute(description="Returns the current percentage of calls which were slower than a certain threshold.")
    public float getSlowCallRate() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getSlowCallRate();
        }
        return 0.0f;
    }

    @ManagedAttribute(description="Returns the current total number of calls which were slower than a certain threshold.")
    public int getNumberOfSlowCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfSlowCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current number of successful calls which were slower than a certain threshold.")
    public int getNumberOfSlowSuccessfulCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfSlowCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current number of failed calls which were slower than a certain threshold.")
    public int getNumberOfSlowFailedCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfSlowFailedCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current total number of buffered calls in the ring buffer.")
    public int getNumberOfBufferedCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfBufferedCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current number of failed buffered calls in the ring buffer.")
    public int getNumberOfFailedCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfFailedCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current number of successful buffered calls in the ring buffer")
    public int getNumberOfSuccessfulCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfSuccessfulCalls();
        }
        return 0;
    }

    @ManagedAttribute(description="Returns the current number of not permitted calls, when the state is OPEN.")
    public long getNumberOfNotPermittedCalls() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getMetrics().getNumberOfNotPermittedCalls();
        }
        return 0L;
    }

    @ManagedAttribute(description="Returns the current state of the circuit breaker")
    public String getCircuitBreakerState() {
        if (this.circuitBreaker != null) {
            return this.circuitBreaker.getState().name();
        }
        return null;
    }

    @ManagedOperation(description="Transitions the circuit breaker to CLOSED state.")
    public void transitionToCloseState() {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.transitionToClosedState();
        }
    }

    @ManagedOperation(description="Transitions the circuit breaker to OPEN state.")
    public void transitionToOpenState() {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.transitionToOpenState();
        }
    }

    @ManagedOperation(description="Transitions the circuit breaker to HALF_OPEN state.")
    public void transitionToHalfOpenState() {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.transitionToHalfOpenState();
        }
    }

    @ManagedOperation(description="Transitions the state machine to a FORCED_OPEN state, stopping state transition, metrics and event publishing.")
    public void transitionToForcedOpenState() {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.transitionToForcedOpenState();
        }
    }

    @ManagedAttribute
    public float getCircuitBreakerFailureRateThreshold() {
        return this.circuitBreakerConfig.getFailureRateThreshold();
    }

    @ManagedAttribute
    public float getCircuitBreakerSlowCallRateThreshold() {
        return this.circuitBreakerConfig.getSlowCallRateThreshold();
    }

    @ManagedAttribute
    public int getCircuitBreakerMinimumNumberOfCalls() {
        return this.circuitBreakerConfig.getMinimumNumberOfCalls();
    }

    @ManagedAttribute
    public int getCircuitBreakerPermittedNumberOfCallsInHalfOpenState() {
        return this.circuitBreakerConfig.getPermittedNumberOfCallsInHalfOpenState();
    }

    @ManagedAttribute
    public int getCircuitBreakerSlidingWindowSize() {
        return this.circuitBreakerConfig.getSlidingWindowSize();
    }

    @ManagedAttribute
    public String getCircuitBreakerSlidingWindowType() {
        return this.circuitBreakerConfig.getSlidingWindowType().name();
    }

    @ManagedAttribute
    public long getCircuitBreakerWaitDurationInOpenState() {
        return this.circuitBreakerConfig.getWaitDurationInOpenState().getSeconds();
    }

    @ManagedAttribute
    public boolean isCircuitBreakerTransitionFromOpenToHalfOpenEnabled() {
        return this.circuitBreakerConfig.isAutomaticTransitionFromOpenToHalfOpenEnabled();
    }

    @ManagedAttribute
    public boolean isCircuitBreakerWritableStackTraceEnabled() {
        return this.circuitBreakerConfig.isWritableStackTraceEnabled();
    }

    @ManagedAttribute
    public boolean isBulkheadEnabled() {
        return this.bulkheadConfig != null;
    }

    @ManagedAttribute
    public int getBulkheadMaxConcurrentCalls() {
        if (this.bulkheadConfig != null) {
            return this.bulkheadConfig.getMaxConcurrentCalls();
        }
        return 0;
    }

    @ManagedAttribute
    public long getBulkheadMaxWaitDuration() {
        if (this.bulkheadConfig != null) {
            return this.bulkheadConfig.getMaxWaitDuration().toMillis();
        }
        return 0L;
    }

    @ManagedAttribute
    public boolean isTimeoutEnabled() {
        return this.timeLimiterConfig != null;
    }

    @ManagedAttribute
    public long getTimeoutDuration() {
        if (this.timeLimiterConfig != null) {
            return this.timeLimiterConfig.getTimeoutDuration().toMillis();
        }
        return 0L;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add(this.processor);
        if (this.fallback != null) {
            answer.add(this.fallback);
        }
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.setProperty("TryRouteBlock", (Object)true);
        Callable task = CircuitBreaker.decorateCallable((CircuitBreaker)this.circuitBreaker, (Callable)new CircuitBreakerTask(this.processor, exchange));
        CircuitBreakerFallbackTask fallbackTask = new CircuitBreakerFallbackTask(this.fallback, exchange);
        if (this.bulkheadConfig != null) {
            Bulkhead bh = Bulkhead.of((String)this.id, (BulkheadConfig)this.bulkheadConfig);
            task = Bulkhead.decorateCallable((Bulkhead)bh, (Callable)task);
        }
        if (this.timeLimiterConfig != null) {
            CircuitBreakerTimeoutTask timeoutTask = new CircuitBreakerTimeoutTask(task, exchange);
            Supplier<CompletableFuture> futureSupplier = this.executorService == null ? () -> CompletableFuture.supplyAsync(timeoutTask::get) : () -> CompletableFuture.supplyAsync(timeoutTask::get, this.executorService);
            TimeLimiter tl = TimeLimiter.of((String)this.id, (TimeLimiterConfig)this.timeLimiterConfig);
            task = TimeLimiter.decorateFutureSupplier((TimeLimiter)tl, futureSupplier);
        }
        Try.ofCallable((Callable)task).recover((Function)fallbackTask).andFinally(() -> callback.done(false)).get();
        return false;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        if (this.circuitBreaker == null) {
            this.circuitBreaker = CircuitBreaker.of((String)this.id, (CircuitBreakerConfig)this.circuitBreakerConfig);
        }
    }

    protected void doStop() throws Exception {
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    private static final class CircuitBreakerTimeoutTask
    implements Supplier<Exchange> {
        private final Callable<Exchange> future;
        private final Exchange exchange;

        private CircuitBreakerTimeoutTask(Callable<Exchange> future, Exchange exchange) {
            this.future = future;
            this.exchange = exchange;
        }

        @Override
        public Exchange get() {
            try {
                return this.future.call();
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
                return this.exchange;
            }
        }
    }

    private static final class CircuitBreakerFallbackTask
    implements Function<Throwable, Exchange> {
        private final Processor processor;
        private final Exchange exchange;

        private CircuitBreakerFallbackTask(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        @Override
        public Exchange apply(Throwable throwable) {
            if (this.processor == null) {
                if (throwable instanceof TimeoutException) {
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseTimedOut", (Object)true);
                    this.exchange.setException(throwable);
                    return this.exchange;
                }
                if (throwable instanceof CallNotPermittedException) {
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)true);
                    this.exchange.setProperty("CamelCircuitBreakerResponseRejected", (Object)true);
                    return this.exchange;
                }
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)throwable);
            }
            this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
            this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)true);
            this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)true);
            if (this.exchange.getProperty("CamelFailureEndpoint") == null) {
                this.exchange.setProperty("CamelFailureEndpoint", this.exchange.getProperty("CamelToEndpoint"));
            }
            this.exchange.setProperty("CamelExceptionHandled", (Object)true);
            this.exchange.setProperty("CamelExceptionCaught", (Object)this.exchange.getException());
            this.exchange.setRouteStop(false);
            this.exchange.setException(null);
            ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
            try {
                LOG.debug("Running fallback: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
                this.processor.process(this.exchange);
                LOG.debug("Running fallback: {} with exchange: {} done", (Object)this.processor, (Object)this.exchange);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return this.exchange;
        }
    }

    private static final class CircuitBreakerTask
    implements Callable<Exchange> {
        private final Processor processor;
        private final Exchange exchange;

        private CircuitBreakerTask(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        @Override
        public Exchange call() throws Exception {
            try {
                LOG.debug("Running processor: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
                Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)this.exchange, (boolean)false, (boolean)false);
                this.processor.process(copy);
                if (copy.getException() != null) {
                    this.exchange.setException((Throwable)copy.getException());
                } else {
                    ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)copy);
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)true);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                }
            }
            catch (Throwable e) {
                this.exchange.setException(e);
            }
            if (this.exchange.getException() != null) {
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)this.exchange.getException());
            }
            return this.exchange;
        }
    }
}

