/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reactive.vertx;

import io.vertx.core.Vertx;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.spi.SimpleExecutorService;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="thread-pool-factory")
public class VertXThreadPoolFactory
extends DefaultThreadPoolFactory
implements ThreadPoolFactory {
    private static final Logger LOG = LoggerFactory.getLogger(VertXThreadPoolFactory.class);
    private final ExecutorService vertxExecutorService = new VertXExecutorService();
    private Vertx vertx;

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    protected void doInit() throws Exception {
        Set set;
        super.doInit();
        if (this.vertx == null && (set = this.getCamelContext().getRegistry().findByType(Vertx.class)).size() == 1) {
            this.vertx = (Vertx)set.iterator().next();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            throw new IllegalArgumentException("VertX instance must be configured.");
        }
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        if (profile.isDefaultProfile().booleanValue()) {
            return this.vertxExecutorService;
        }
        return super.newThreadPool(profile, threadFactory);
    }

    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return this.vertxExecutorService;
    }

    public String toString() {
        return "camel-threadpoolfactory-vertx";
    }

    private class VertXExecutorService
    implements ExecutorService,
    SimpleExecutorService {
        private VertXExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            LOG.trace("submit: {}", (Object)task);
            CompletableFuture answer = new CompletableFuture();
            VertXThreadPoolFactory.this.vertx.executeBlocking(future -> {
                task.run();
                future.complete();
            }, res -> answer.complete(null));
            return answer;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
            LOG.trace("execute: {}", (Object)command);
            VertXThreadPoolFactory.this.vertx.executeBlocking(future -> {
                command.run();
                future.complete();
            }, null);
        }
    }
}

