/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationProcessMsg;
import ca.uhn.fhir.rest.gclient.IOperationProcessMsgMode;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.util.ObjectHelper;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirOperation {
    private final IGenericClient client;

    public FhirOperation(IGenericClient client) {
        this.client = client;
    }

    public <T extends IBaseParameters> IBaseResource onType(Class<IBaseResource> resourceType, String name, T parameters, Class<T> outputParameterType, boolean useHttpGet, Class<IBaseResource> returnType, Map<ExtraParameters, Object> extraParameters) {
        IOperationUnnamed operationUnnamed = (IOperationUnnamed)this.client.operation().onType(resourceType);
        IOperationUntypedWithInput<IBaseResource> operationUntypedWithInput = this.processNamedOperationParameters(name, parameters, outputParameterType, useHttpGet, returnType, extraParameters, operationUnnamed);
        return (IBaseResource)operationUntypedWithInput.execute();
    }

    public <T extends IBaseParameters> IBaseResource onServer(String name, T parameters, Class<T> outputParameterType, boolean useHttpGet, Class<IBaseResource> returnType, Map<ExtraParameters, Object> extraParameters) {
        IOperationUnnamed operationUnnamed = (IOperationUnnamed)this.client.operation().onServer();
        IOperationUntypedWithInput<IBaseResource> operationUntypedWithInput = this.processNamedOperationParameters(name, parameters, outputParameterType, useHttpGet, returnType, extraParameters, operationUnnamed);
        return (IBaseResource)operationUntypedWithInput.execute();
    }

    public <T extends IBaseParameters> IBaseResource onInstance(IIdType id, String name, T parameters, Class<T> outputParameterType, boolean useHttpGet, Class<IBaseResource> returnType, Map<ExtraParameters, Object> extraParameters) {
        IOperationUnnamed operationUnnamed = this.client.operation().onInstanceVersion(id);
        IOperationUntypedWithInput<IBaseResource> operationUntypedWithInput = this.processNamedOperationParameters(name, parameters, outputParameterType, useHttpGet, returnType, extraParameters, operationUnnamed);
        return (IBaseResource)operationUntypedWithInput.execute();
    }

    public <T extends IBaseParameters> IBaseResource onInstanceVersion(IIdType id, String name, T parameters, Class<T> outputParameterType, boolean useHttpGet, Class<IBaseResource> returnType, Map<ExtraParameters, Object> extraParameters) {
        IOperationUnnamed operationUnnamed = this.client.operation().onInstanceVersion(id);
        IOperationUntypedWithInput<IBaseResource> operationUntypedWithInput = this.processNamedOperationParameters(name, parameters, outputParameterType, useHttpGet, returnType, extraParameters, operationUnnamed);
        return (IBaseResource)operationUntypedWithInput.execute();
    }

    public <T extends IBaseBundle> T processMessage(String respondToUri, IBaseBundle msgBundle, boolean asynchronous, Class<T> responseClass, Map<ExtraParameters, Object> extraParameters) {
        IOperationProcessMsg operationProcessMsg = this.client.operation().processMessage();
        if (ObjectHelper.isNotEmpty((Object)respondToUri)) {
            operationProcessMsg.setResponseUrlParam(respondToUri);
        }
        IOperationProcessMsgMode operationProcessMsgMode = operationProcessMsg.setMessageBundle(msgBundle);
        if (asynchronous) {
            operationProcessMsgMode.asynchronous(responseClass);
        } else {
            operationProcessMsgMode.synchronous(responseClass);
        }
        ExtraParameters.process(extraParameters, operationProcessMsgMode);
        return (T)((IBaseBundle)operationProcessMsgMode.execute());
    }

    private <T extends IBaseParameters> IOperationUntypedWithInput<? extends IBaseResource> processNamedOperationParameters(String name, T parameters, Class<T> outputParameterType, boolean useHttpGet, Class<? extends IBaseResource> returnType, Map<ExtraParameters, Object> extraParameters, IOperationUnnamed operationUnnamed) {
        IOperationUntyped named = operationUnnamed.named(name);
        Object operationUntypedWithInput = outputParameterType != null ? named.withNoParameters(outputParameterType) : named.withParameters(parameters);
        if (useHttpGet) {
            operationUntypedWithInput.useHttpGet();
        }
        if (returnType != null) {
            operationUntypedWithInput.returnResourceType(returnType);
        }
        ExtraParameters.process(extraParameters, operationUntypedWithInput);
        return operationUntypedWithInput;
    }
}

