/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.camel.component.as2.api.AS2ServerManager;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.PropertyNamesInterceptor;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2Consumer
extends AbstractApiConsumer<AS2ApiName, AS2Configuration>
implements HttpRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AS2Consumer.class);
    private static final String HANDLER_PROPERTY = "handler";
    private static final String REQUEST_URI_PROPERTY = "requestUri";
    private AS2ServerConnection as2ServerConnection;
    private AS2ServerManager apiProxy;
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;

    public AS2Consumer(AS2Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod((AbstractApiEndpoint)endpoint, (PropertyNamesInterceptor)this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(HANDLER_PROPERTY, (Object)this);
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(HANDLER_PROPERTY);
    }

    protected int poll() throws Exception {
        return 0;
    }

    public AS2Endpoint getEndpoint() {
        return (AS2Endpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.as2ServerConnection = this.getEndpoint().getAS2ServerConnection();
        this.apiProxy = new AS2ServerManager(this.as2ServerConnection);
        ApiMethodHelper.invokeMethod((Object)this.apiProxy, (ApiMethod)this.apiMethod, this.properties);
    }

    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            String requestUri = (String)this.properties.get(REQUEST_URI_PROPERTY);
            this.apiProxy.stopListening(requestUri);
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
        Exception exception;
        try {
            if (request instanceof HttpEntityEnclosingRequest) {
                EntityParser.parseAS2MessageEntity((HttpMessage)request);
                this.apiProxy.handleMDNResponse((HttpEntityEnclosingRequest)request, response, context, "MDN Response", "Camel AS2 Server Endpoint");
            }
            ApplicationEDIEntity ediEntity = HttpMessageUtils.extractEdiPayload((HttpMessage)request, (PrivateKey)this.as2ServerConnection.getDecryptingPrivateKey());
            Exchange exchange = this.getEndpoint().createExchange();
            HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
            exchange.setProperty("CamelAS2.interchange", (Object)coreContext);
            exchange.getIn().setBody((Object)ediEntity.getEdiMessage());
            try {
                this.getProcessor().process(exchange);
            }
            finally {
                exception = exchange.getException();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to process AS2 message", (Throwable)e);
            exception = e;
        }
        if (exception != null) {
            throw new HttpException("Failed to process AS2 message: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

