/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.client.Sns2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class Sns2ClientIAMOptimized
implements Sns2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Sns2ClientIAMOptimized.class);
    private Sns2Configuration configuration;

    public Sns2ClientIAMOptimized(Sns2Configuration configuration) {
        LOG.trace("Creating an AWS SNS client for working on AWS Services");
        this.configuration = configuration;
    }

    @Override
    public SnsClient getSNSClient() {
        SnsClient client = null;
        SnsClientBuilder clientBuilder = SnsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            DefaultCredentialsProvider cred = DefaultCredentialsProvider.create();
            clientBuilder = isClientConfigFound ? (SnsClientBuilder)((SnsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)cred) : (SnsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)cred);
        } else if (!isClientConfigFound) {
            clientBuilder = (SnsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (SnsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (SnsClient)clientBuilder.build();
        return client;
    }
}

