/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SolrEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":url";
    private static final String[] SCHEMES = new String[]{"solr", "solrs", "solrCloud"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "url", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(17);
        props.add("defaultMaxConnectionsPerHost");
        props.add("synchronous");
        props.add("maxTotalConnections");
        props.add("streamingThreadCount");
        props.add("collection");
        props.add("zkHost");
        props.add("soTimeout");
        props.add("url");
        props.add("lazyStartProducer");
        props.add("maxRetries");
        props.add("password");
        props.add("allowCompression");
        props.add("requestHandler");
        props.add("followRedirects");
        props.add("streamingQueueSize");
        props.add("connectionTimeout");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

