/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GroupIterator;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;

public final class CSimpleHelper {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)(\\.\\.)(\\d+)$");
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");
    private static ExchangeFormatter exchangeFormatter;
    private static Language beanLanguage;

    private CSimpleHelper() {
    }

    public static <T> T bodyAs(Message message, Class<T> type) {
        return (T)message.getBody(type);
    }

    public static <T> T mandatoryBodyAs(Message message, Class<T> type) throws InvalidPayloadException {
        return (T)message.getMandatoryBody(type);
    }

    public static <T> T bodyAsIndex(Message message, Class<T> type, int key) {
        return CSimpleHelper.bodyAsIndex(message, type, "" + key);
    }

    public static <T> T bodyAsIndex(Message message, Class<T> type, String key) {
        Object obj = message.getBody();
        Object objKey = CSimpleHelper.doObjectAsIndex(message.getExchange().getContext(), obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List keys = OgnlHelper.splitOgnl((String)key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between((String)k, (String)"[", (String)"]");
            }
            obj = CSimpleHelper.doObjectAsIndex(message.getExchange().getContext(), obj, k);
        }
        return type.cast(obj);
    }

    public static <T> T mandatoryBodyAsIndex(Message message, Class<T> type, int key) throws InvalidPayloadException {
        T out = CSimpleHelper.bodyAsIndex(message, type, "" + key);
        if (out == null) {
            throw new InvalidPayloadException(message.getExchange(), type, message);
        }
        return out;
    }

    public static <T> T mandatoryBodyAsIndex(Message message, Class<T> type, String key) throws InvalidPayloadException {
        T out = CSimpleHelper.bodyAsIndex(message, type, key);
        if (out == null) {
            throw new InvalidPayloadException(message.getExchange(), type, message);
        }
        return out;
    }

    public static Object header(Message message, String name) {
        return message.getHeader(name);
    }

    public static <T> T headerAs(Message message, String name, Class<T> type) {
        return (T)message.getHeader(name, type);
    }

    public static <T> T headerAsIndex(Message message, Class<T> type, String name, String key) {
        Object obj = message.getHeader(name);
        Object objKey = CSimpleHelper.doObjectAsIndex(message.getExchange().getContext(), obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List keys = OgnlHelper.splitOgnl((String)key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between((String)k, (String)"[", (String)"]");
            }
            obj = CSimpleHelper.doObjectAsIndex(message.getExchange().getContext(), obj, k);
        }
        return type.cast(obj);
    }

    public static Object exchangeProperty(Exchange exchange, String name) {
        return exchange.getProperty(name);
    }

    public static <T> T exchangePropertyAs(Exchange exchange, String name, Class<T> type) {
        return (T)exchange.getProperty(name, type);
    }

    public static <T> T exchangePropertyAsIndex(Exchange exchange, Class<T> type, String name, String key) {
        Object obj = exchange.getProperty(name);
        Object objKey = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List keys = OgnlHelper.splitOgnl((String)key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between((String)k, (String)"[", (String)"]");
            }
            obj = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, k);
        }
        return type.cast(obj);
    }

    public static String bodyOneLine(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        if (body == null) {
            return null;
        }
        body = StringHelper.replaceAll((String)body, (String)System.lineSeparator(), (String)"");
        return body;
    }

    public static Exception exception(Exchange exchange) {
        Exception exception = exchange.getException();
        if (exception == null) {
            exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        return exception;
    }

    public static <T> T exceptionAs(Exchange exchange, Class<T> type) {
        Exception exception = exchange.getException();
        if (exception == null) {
            exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        if (exception != null) {
            return type.cast(exception);
        }
        return null;
    }

    public static String exceptionMessage(Exchange exchange) {
        Exception exception = CSimpleHelper.exception(exchange);
        if (exception != null) {
            return exception.getMessage();
        }
        return null;
    }

    public static String exceptionStacktrace(Exchange exchange) {
        Exception exception = CSimpleHelper.exception(exchange);
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            IOHelper.close((Closeable[])new Closeable[]{pw, sw});
            return sw.toString();
        }
        return null;
    }

    public static String threadName() {
        return Thread.currentThread().getName();
    }

    public static String hostName() {
        return InetAddressUtil.getLocalHostNameSafe();
    }

    public static String routeId(Exchange exchange) {
        return ExchangeHelper.getRouteId((Exchange)exchange);
    }

    public static String stepId(Exchange exchange) {
        return (String)exchange.getProperty("CamelStepId", String.class);
    }

    public static String fileName(Message message) {
        return (String)message.getHeader("CamelFileName", String.class);
    }

    public static String fileNameNoExt(Message message) {
        String name = (String)message.getHeader("CamelFileName", String.class);
        return FileUtil.stripExt((String)name);
    }

    public static String fileNameNoExtSingle(Message message) {
        String name = (String)message.getHeader("CamelFileName", String.class);
        return FileUtil.stripExt((String)name, (boolean)true);
    }

    public static String fileNameExt(Message message) {
        String name = (String)message.getHeader("CamelFileName", String.class);
        return FileUtil.onlyExt((String)name);
    }

    public static String fileNameExtSingle(Message message) {
        String name = (String)message.getHeader("CamelFileName", String.class);
        return FileUtil.onlyExt((String)name, (boolean)true);
    }

    public static String fileOnlyName(Message message) {
        String answer = (String)message.getHeader("CamelFileNameOnly", String.class);
        if (answer == null) {
            answer = (String)message.getHeader("CamelFileName", String.class);
            answer = FileUtil.stripPath((String)answer);
        }
        return answer;
    }

    public static String fileOnlyNameNoExt(Message message) {
        String name = CSimpleHelper.fileOnlyName(message);
        return FileUtil.stripExt((String)name);
    }

    public static String fileOnlyNameNoExtSingle(Message message) {
        String name = CSimpleHelper.fileOnlyName(message);
        return FileUtil.stripExt((String)name, (boolean)true);
    }

    public static String fileParent(Message message) {
        return (String)message.getHeader("CamelFileParent", String.class);
    }

    public static String filePath(Message message) {
        return (String)message.getHeader("CamelFilePath", String.class);
    }

    public static Boolean fileAbsolute(Message message) {
        return (Boolean)message.getHeader("CamelFileAbsolute", Boolean.class);
    }

    public static String fileAbsolutePath(Message message) {
        return (String)message.getHeader("CamelFileAbsolutePath", String.class);
    }

    public static Long fileSize(Message message) {
        return (Long)message.getHeader("CamelFileLength", Long.class);
    }

    public static Long fileModified(Message message) {
        return (Long)message.getHeader("CamelFileLastModified", Long.class);
    }

    public static Date date(Exchange exchange, String commandWithOffsets) {
        return (Date)CSimpleHelper.doDate(exchange, commandWithOffsets, null, null);
    }

    public static String date(Exchange exchange, String commandWithOffsets, String timezone, String pattern) {
        return (String)CSimpleHelper.doDate(exchange, commandWithOffsets, timezone, pattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object doDate(Exchange exchange, String commandWithOffsets, String timezone, String pattern) {
        Object obj;
        Date date;
        String command = commandWithOffsets.split("[+-]", 2)[0].trim();
        ArrayList<Long> offsets = new ArrayList<Long>();
        Matcher offsetMatcher = OFFSET_PATTERN.matcher(commandWithOffsets);
        while (offsetMatcher.find()) {
            String time = offsetMatcher.group(2).trim();
            long value = TimeUtils.toMilliSeconds((String)time);
            offsets.add(offsetMatcher.group(1).equals("+") ? value : -value);
        }
        if ("now".equals(command)) {
            date = new Date();
        } else if ("exchangeCreated".equals(command)) {
            long num = exchange.getCreated();
            date = new Date(num);
        } else if (command.startsWith("header.")) {
            String key = command.substring(command.lastIndexOf(46) + 1);
            obj = exchange.getMessage().getHeader(key);
            if (obj instanceof Date) {
                date = (Date)obj;
            } else {
                if (!(obj instanceof Long)) throw new IllegalArgumentException("Cannot find Date/long object at command: " + command);
                date = new Date((Long)obj);
            }
        } else if (command.startsWith("exchangeProperty.")) {
            String key = command.substring(command.lastIndexOf(46) + 1);
            obj = exchange.getProperty(key);
            if (obj instanceof Date) {
                date = (Date)obj;
            } else {
                if (!(obj instanceof Long)) throw new IllegalArgumentException("Cannot find Date/long object at command: " + command);
                date = new Date((Long)obj);
            }
        } else {
            if (!"file".equals(command)) throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
            Long num = (Long)exchange.getIn().getHeader("CamelFileLastModified", Long.class);
            if (num != null && num > 0L) {
                date = new Date(num);
            } else {
                date = (Date)exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                if (date == null) {
                    throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
                }
            }
        }
        long dateAsLong = date.getTime();
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            dateAsLong += offset;
        }
        date = new Date(dateAsLong);
        if (pattern == null || pattern.isEmpty()) return date;
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        if (timezone == null || timezone.isEmpty()) return df.format(date);
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        return df.format(date);
    }

    public static String property(Exchange exchange, String key, String defaultValue) {
        try {
            PropertiesComponent pc = exchange.getContext().getPropertiesComponent();
            return pc.parseUri("{{" + key + "}}");
        }
        catch (Exception e) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public static Object ref(Exchange exchange, String key) {
        return exchange.getContext().getRegistry().lookupByName(key);
    }

    public static Class<?> type(Exchange exchange, Class<?> type) {
        return type;
    }

    public static Object type(Exchange exchange, Class<?> type, String field) {
        return org.apache.camel.util.ObjectHelper.lookupConstantFieldValue(type, (String)field);
    }

    public static Object bean(Exchange exchange, String ref, String method, Object scope) {
        Class type = null;
        if (ref != null && ref.startsWith("type:")) {
            try {
                type = exchange.getContext().getClassResolver().resolveMandatoryClass(ref.substring(5));
                ref = null;
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        Language bean = CSimpleHelper.getOrCreateBeanLanguage(exchange.getContext());
        Object[] properties = new Object[5];
        properties[2] = type;
        properties[3] = ref;
        properties[1] = method;
        properties[4] = scope;
        Expression exp = bean.createExpression(null, properties);
        exp.init(exchange.getContext());
        return exp.evaluate(exchange, Object.class);
    }

    private static Language getOrCreateBeanLanguage(CamelContext camelContext) {
        if (beanLanguage == null) {
            beanLanguage = camelContext.resolveLanguage("bean");
        }
        return beanLanguage;
    }

    public static Object increment(Exchange exchange, Object number) {
        Number num = (Number)exchange.getContext().getTypeConverter().tryConvertTo(Number.class, exchange, number);
        if (num instanceof Integer) {
            int val = num.intValue();
            return ++val;
        }
        if (num instanceof Long) {
            long val = num.longValue();
            return ++val;
        }
        CamelExchangeException cause = new CamelExchangeException("Cannot evaluate message body as a number", exchange);
        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)cause);
    }

    public static Object decrement(Exchange exchange, Object number) {
        Number num = (Number)exchange.getContext().getTypeConverter().tryConvertTo(Number.class, exchange, number);
        if (num instanceof Integer) {
            int val = num.intValue();
            return --val;
        }
        if (num instanceof Long) {
            long val = num.longValue();
            return --val;
        }
        CamelExchangeException cause = new CamelExchangeException("Cannot evaluate message body as a number", exchange);
        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)cause);
    }

    public static int random(Exchange exchange, Object min, Object max) {
        int num1 = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, min);
        int num2 = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, max);
        Random random = new Random();
        return random.nextInt(num2 - num1) + num1;
    }

    public static SkipIterator skip(Exchange exchange, Object skip) {
        int num = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, skip);
        Iterator it = ObjectHelper.createIterator((Object)exchange.getMessage().getBody());
        return new SkipIterator(it, num);
    }

    public static GroupIterator collate(Exchange exchange, Object group) {
        int num = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, group);
        Iterator it = ObjectHelper.createIterator((Object)exchange.getMessage().getBody());
        return new GroupIterator(exchange, it, num);
    }

    public static String messageHistory(Exchange exchange, boolean detailed) {
        ExchangeFormatter formatter = CSimpleHelper.getOrCreateExchangeFormatter(exchange.getContext());
        return MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)formatter, (boolean)detailed);
    }

    public static String sys(String name) {
        return System.getProperty(name);
    }

    public static String sysenv(String name) {
        String answer = null;
        if (name != null && (answer = System.getenv(name = name.toUpperCase())) == null) {
            String noDashKey = name.replace('-', '_');
            answer = System.getenv(noDashKey);
        }
        return answer;
    }

    private static ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
        if (exchangeFormatter == null) {
            Set formatters = camelContext.getRegistry().findByType(ExchangeFormatter.class);
            if (formatters != null && formatters.size() == 1) {
                exchangeFormatter = (ExchangeFormatter)formatters.iterator().next();
            } else {
                DefaultExchangeFormatter def = new DefaultExchangeFormatter();
                def.setShowExchangeId(true);
                def.setMultiline(true);
                def.setShowHeaders(true);
                def.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
                try {
                    Integer maxChars = CamelContextHelper.parseInteger((CamelContext)camelContext, (String)camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                    if (maxChars != null) {
                        def.setMaxChars(maxChars.intValue());
                    }
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
                exchangeFormatter = def;
            }
        }
        return exchangeFormatter;
    }

    public static boolean isEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue);
    }

    public static boolean isEqualToIgnoreCase(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue, (boolean)true);
    }

    public static boolean isNotEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceNotEquals((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue);
    }

    public static boolean isGreaterThan(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue) > 0;
    }

    public static boolean isGreaterThanOrEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue) >= 0;
    }

    public static boolean isLessThan(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue) < 0;
    }

    public static boolean isLessThanOrEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue) <= 0;
    }

    public static boolean contains(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return ObjectHelper.typeCoerceContains((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue, (boolean)false);
    }

    public static boolean containsIgnoreCase(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return ObjectHelper.typeCoerceContains((TypeConverter)exchange.getContext().getTypeConverter(), (Object)leftValue, (Object)rightValue, (boolean)true);
    }

    public static boolean regexp(Exchange exchange, Object leftValue, Object rightValue) {
        String text = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, leftValue);
        String pattern = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, rightValue);
        return text.matches(pattern);
    }

    public static boolean in(Exchange exchange, Object leftValue, Object rightValue) {
        Iterator it = ObjectHelper.createIterator((Object)rightValue);
        ArrayList values = new ArrayList();
        while (it.hasNext()) {
            values.add(it.next());
        }
        for (Object value : values) {
            if (!CSimpleHelper.isEqualTo(exchange, leftValue, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean range(Exchange exchange, Object leftValue, Object rightValue) {
        String range = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, rightValue);
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (matcher.matches()) {
            String from = matcher.group(1);
            String to = matcher.group(3);
            return CSimpleHelper.isGreaterThanOrEqualTo(exchange, leftValue, from) && CSimpleHelper.isLessThanOrEqualTo(exchange, leftValue, to);
        }
        throw new IllegalArgumentException("Range operator is not valid. Valid syntax:'from..to' (where from and to are numbers).");
    }

    public static boolean startsWith(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        String leftStr = (String)exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
        String rightStr = (String)exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
        if (leftStr != null && rightStr != null) {
            return leftStr.startsWith(rightStr);
        }
        return false;
    }

    public static boolean endsWith(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        String leftStr = (String)exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
        String rightStr = (String)exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
        if (leftStr != null && rightStr != null) {
            return leftStr.endsWith(rightStr);
        }
        return false;
    }

    public static boolean is(Exchange exchange, Object leftValue, Class<?> type) {
        return type.isInstance(leftValue);
    }

    private static Object doObjectAsIndex(CamelContext context, Object obj, String key) {
        if (obj != null && obj.getClass().isArray()) {
            int size = Array.getLength(obj);
            Integer num = CSimpleHelper.indexAsNumber(context, key, size);
            if (num != null && num >= 0 && size > 0 && size > num - 1) {
                obj = Array.get(obj, num);
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            Integer num = CSimpleHelper.indexAsNumber(context, key, list.size());
            if (num != null && num >= 0 && !list.isEmpty() && list.size() > num - 1) {
                obj = list.get(num);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            obj = map.get(key);
        } else {
            return null;
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Integer indexAsNumber(CamelContext context, String key, int size) {
        if (!key.startsWith("last")) return (Integer)context.getTypeConverter().tryConvertTo(Integer.class, (Object)key);
        Integer num = size - 1;
        String after = StringHelper.after((String)key, (String)"-");
        if (after == null) return num;
        Integer redux = (Integer)context.getTypeConverter().tryConvertTo(Integer.class, (Object)after.trim());
        if (redux == null) throw new ExpressionIllegalSyntaxException(key);
        return num - redux;
    }
}

