/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.workday.WorkdayComponent;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.producer.WorkdayCommonAPIProducer;
import org.apache.camel.component.workday.producer.WorkdayReportProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.1.0", scheme="workday", title="Workday", syntax="workday:entity:path", producerOnly=true, category={Category.CLOUD, Category.API, Category.HCM})
public class WorkdayEndpoint
extends DefaultEndpoint {
    @UriParam
    private WorkdayConfiguration workdayConfiguration;

    public WorkdayEndpoint() {
    }

    public WorkdayEndpoint(String uri, WorkdayComponent component, WorkdayConfiguration configuration) {
        super(uri, (Component)component);
        this.workdayConfiguration = configuration;
    }

    public Producer createProducer() throws Exception {
        switch (this.workdayConfiguration.getEntity()) {
            case report: {
                return new WorkdayReportProducer(this);
            }
            case commonAPI: {
                return new WorkdayCommonAPIProducer(this);
            }
        }
        throw new UnsupportedOperationException(String.format("Workday producer %s is not implemented", new Object[]{this.workdayConfiguration.getEntity()}));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Workday consumer is not implemented.");
    }

    public boolean isLenientProperties() {
        return true;
    }

    public WorkdayConfiguration getWorkdayConfiguration() {
        return this.workdayConfiguration;
    }

    public void setWorkdayConfiguration(WorkdayConfiguration workdayConfiguration) {
        this.workdayConfiguration = workdayConfiguration;
    }
}

