/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Sending and receive messages to/from AWS SQS service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SqsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface SqsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSqsEndpointConsumerBuilder advanced() {
            return (AdvancedSqsEndpointConsumerBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: amazonaws.com
         * Group: common
         */
        default SqsEndpointConsumerBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a: <code>com.amazonaws.services.sqs.AmazonSQS</code>
         * type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder amazonSQSClient(
                Object amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.sqs.AmazonSQS</code> type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder amazonSQSClient(
                String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointConsumerBuilder autoCreateQueue(
                boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointConsumerBuilder autoCreateQueue(
                String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointConsumerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointConsumerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https
         * Group: common
         */
        default SqsEndpointConsumerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a: <code>com.amazonaws.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointConsumerBuilder proxyProtocol(Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a <code>com.amazonaws.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * Specify the queue region which could be used with
         * queueOwnerAWSAccountId to build the service URL. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * A list of attribute names to receive when consuming. Multiple names
         * can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder attributeNames(String attributeNames) {
            doSetProperty("attributeNames", attributeNames);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows you to use multiple threads to poll the sqs queue to increase
         * throughput.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Allows you to use multiple threads to poll the sqs queue to increase
         * throughput.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The default visibility timeout (in seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder defaultVisibilityTimeout(
                Integer defaultVisibilityTimeout) {
            doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }
        /**
         * The default visibility timeout (in seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder defaultVisibilityTimeout(
                String defaultVisibilityTimeout) {
            doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }
        /**
         * Delete message from SQS after it has been read.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder deleteAfterRead(
                boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete message from SQS after it has been read.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder deleteAfterRead(
                String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Whether or not to send the DeleteMessage to the SQS queue if an
         * exchange fails to get through a filter. If 'false' and exchange does
         * not make it through a Camel filter upstream in the route, then don't
         * send DeleteMessage.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder deleteIfFiltered(
                boolean deleteIfFiltered) {
            doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }
        /**
         * Whether or not to send the DeleteMessage to the SQS queue if an
         * exchange fails to get through a filter. If 'false' and exchange does
         * not make it through a Camel filter upstream in the route, then don't
         * send DeleteMessage.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder deleteIfFiltered(
                String deleteIfFiltered) {
            doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }
        /**
         * If enabled then a scheduled background task will keep extending the
         * message visibility on SQS. This is needed if it takes a long time to
         * process the message. If set to true defaultVisibilityTimeout must be
         * set. See details at Amazon docs.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder extendMessageVisibility(
                boolean extendMessageVisibility) {
            doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }
        /**
         * If enabled then a scheduled background task will keep extending the
         * message visibility on SQS. This is needed if it takes a long time to
         * process the message. If set to true defaultVisibilityTimeout must be
         * set. See details at Amazon docs.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder extendMessageVisibility(
                String extendMessageVisibility) {
            doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }
        /**
         * The length of time, in seconds, for which Amazon SQS can reuse a data
         * key to encrypt or decrypt messages before calling AWS KMS again. An
         * integer representing seconds, between 60 seconds (1 minute) and
         * 86,400 seconds (24 hours). Default: 300 (5 minutes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder kmsDataKeyReusePeriodSeconds(
                Integer kmsDataKeyReusePeriodSeconds) {
            doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }
        /**
         * The length of time, in seconds, for which Amazon SQS can reuse a data
         * key to encrypt or decrypt messages before calling AWS KMS again. An
         * integer representing seconds, between 60 seconds (1 minute) and
         * 86,400 seconds (24 hours). Default: 300 (5 minutes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder kmsDataKeyReusePeriodSeconds(
                String kmsDataKeyReusePeriodSeconds) {
            doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }
        /**
         * The ID of an AWS-managed customer master key (CMK) for Amazon SQS or
         * a custom CMK.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * A list of message attribute names to receive when consuming. Multiple
         * names can be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder messageAttributeNames(
                String messageAttributeNames) {
            doSetProperty("messageAttributeNames", messageAttributeNames);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Define if Server Side Encryption is enabled or not on the queue.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder serverSideEncryptionEnabled(
                boolean serverSideEncryptionEnabled) {
            doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }
        /**
         * Define if Server Side Encryption is enabled or not on the queue.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder serverSideEncryptionEnabled(
                String serverSideEncryptionEnabled) {
            doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }
        /**
         * The duration (in seconds) that the received messages are hidden from
         * subsequent retrieve requests after being retrieved by a
         * ReceiveMessage request to set in the
         * com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only
         * make sense if its different from defaultVisibilityTimeout. It changes
         * the queue visibility timeout attribute permanently.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder visibilityTimeout(
                Integer visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The duration (in seconds) that the received messages are hidden from
         * subsequent retrieve requests after being retrieved by a
         * ReceiveMessage request to set in the
         * com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only
         * make sense if its different from defaultVisibilityTimeout. It changes
         * the queue visibility timeout attribute permanently.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Duration in seconds (0 to 20) that the ReceiveMessage action call
         * will wait until a message is in the queue to include in the response.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder waitTimeSeconds(
                Integer waitTimeSeconds) {
            doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }
        /**
         * Duration in seconds (0 to 20) that the ReceiveMessage action call
         * will wait until a message is in the queue to include in the response.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default SqsEndpointConsumerBuilder waitTimeSeconds(
                String waitTimeSeconds) {
            doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default SqsEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder maximumMessageSize(
                Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder maximumMessageSize(
                String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointConsumerBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default SqsEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS Simple Queue Service
     * (SQS) component.
     */
    public interface AdvancedSqsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SqsEndpointConsumerBuilder basic() {
            return (SqsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSqsEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointConsumerBuilder delayQueue(boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointConsumerBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSqsEndpointConsumerBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface SqsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSqsEndpointProducerBuilder advanced() {
            return (AdvancedSqsEndpointProducerBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: amazonaws.com
         * Group: common
         */
        default SqsEndpointProducerBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a: <code>com.amazonaws.services.sqs.AmazonSQS</code>
         * type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder amazonSQSClient(
                Object amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.sqs.AmazonSQS</code> type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder amazonSQSClient(
                String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointProducerBuilder autoCreateQueue(
                boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointProducerBuilder autoCreateQueue(
                String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointProducerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointProducerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https
         * Group: common
         */
        default SqsEndpointProducerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a: <code>com.amazonaws.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointProducerBuilder proxyProtocol(Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a <code>com.amazonaws.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * Specify the queue region which could be used with
         * queueOwnerAWSAccountId to build the service URL. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Delay sending messages for a number of seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder delaySeconds(Integer delaySeconds) {
            doSetProperty("delaySeconds", delaySeconds);
            return this;
        }
        /**
         * Delay sending messages for a number of seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder delaySeconds(String delaySeconds) {
            doSetProperty("delaySeconds", delaySeconds);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SqsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SqsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageDeduplicationId
         * on the message. Can be one of the following options: useExchangeId,
         * useContentBasedDeduplication. For the useContentBasedDeduplication
         * option, no messageDeduplicationId will be set on the message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.sqs.MessageDeduplicationIdStrategy</code> type.
         * 
         * Default: useExchangeId
         * Group: producer
         */
        default SqsEndpointProducerBuilder messageDeduplicationIdStrategy(
                Object messageDeduplicationIdStrategy) {
            doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageDeduplicationId
         * on the message. Can be one of the following options: useExchangeId,
         * useContentBasedDeduplication. For the useContentBasedDeduplication
         * option, no messageDeduplicationId will be set on the message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws.sqs.MessageDeduplicationIdStrategy</code> type.
         * 
         * Default: useExchangeId
         * Group: producer
         */
        default SqsEndpointProducerBuilder messageDeduplicationIdStrategy(
                String messageDeduplicationIdStrategy) {
            doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageGroupId on the
         * message. Can be one of the following options: useConstant,
         * useExchangeId, usePropertyValue. For the usePropertyValue option, the
         * value of property CamelAwsMessageGroupId will be used.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.sqs.MessageGroupIdStrategy</code> type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder messageGroupIdStrategy(
                Object messageGroupIdStrategy) {
            doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageGroupId on the
         * message. Can be one of the following options: useConstant,
         * useExchangeId, usePropertyValue. For the usePropertyValue option, the
         * value of property CamelAwsMessageGroupId will be used.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws.sqs.MessageGroupIdStrategy</code> type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder messageGroupIdStrategy(
                String messageGroupIdStrategy) {
            doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }
        /**
         * The operation to do in case the user don't want to send only a
         * message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.sqs.SqsOperations</code> type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder operation(SqsOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to do in case the user don't want to send only a
         * message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws.sqs.SqsOperations</code> type.
         * 
         * Group: producer
         */
        default SqsEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default SqsEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder maximumMessageSize(
                Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder maximumMessageSize(
                String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointProducerBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS Simple Queue Service
     * (SQS) component.
     */
    public interface AdvancedSqsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SqsEndpointProducerBuilder basic() {
            return (SqsEndpointProducerBuilder) this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointProducerBuilder delayQueue(boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointProducerBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSqsEndpointProducerBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS Simple Queue Service (SQS) component.
     */
    public interface SqsEndpointBuilder
            extends
                SqsEndpointConsumerBuilder,
                SqsEndpointProducerBuilder {
        default AdvancedSqsEndpointBuilder advanced() {
            return (AdvancedSqsEndpointBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: amazonaws.com
         * Group: common
         */
        default SqsEndpointBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a: <code>com.amazonaws.services.sqs.AmazonSQS</code>
         * type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder amazonSQSClient(Object amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.sqs.AmazonSQS</code> type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder amazonSQSClient(String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointBuilder autoCreateQueue(boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointBuilder autoCreateQueue(String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default SqsEndpointBuilder autoDiscoverClient(String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https
         * Group: common
         */
        default SqsEndpointBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a: <code>com.amazonaws.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a <code>com.amazonaws.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: common
         */
        default SqsEndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * Specify the queue region which could be used with
         * queueOwnerAWSAccountId to build the service URL. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SqsEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default SqsEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default SqsEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder maximumMessageSize(Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder maximumMessageSize(String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: queue
         */
        default SqsEndpointBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SqsEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface AdvancedSqsEndpointBuilder
            extends
                AdvancedSqsEndpointConsumerBuilder,
                AdvancedSqsEndpointProducerBuilder {
        default SqsEndpointBuilder basic() {
            return (SqsEndpointBuilder) this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointBuilder delayQueue(boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSqsEndpointBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSqsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.amazonaws.Protocol</code> enum.
     */
    enum Protocol {
        HTTP,
        HTTPS;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.aws.sqs.SqsOperations</code> enum.
     */
    enum SqsOperations {
        sendBatchMessage,
        deleteMessage,
        listQueues;
    }

    public interface SqsBuilders {
        /**
         * AWS Simple Queue Service (SQS) (camel-aws-sqs)
         * Sending and receive messages to/from AWS SQS service.
         * 
         * Category: cloud,messaging
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-aws-sqs
         * 
         * Syntax: <code>aws-sqs:queueNameOrArn</code>
         * 
         * Path parameter: queueNameOrArn (required)
         * Queue name or ARN
         * 
         * @param path queueNameOrArn
         */
        default SqsEndpointBuilder awsSqs(String path) {
            return SqsEndpointBuilderFactory.endpointBuilder("aws-sqs", path);
        }
        /**
         * AWS Simple Queue Service (SQS) (camel-aws-sqs)
         * Sending and receive messages to/from AWS SQS service.
         * 
         * Category: cloud,messaging
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-aws-sqs
         * 
         * Syntax: <code>aws-sqs:queueNameOrArn</code>
         * 
         * Path parameter: queueNameOrArn (required)
         * Queue name or ARN
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path queueNameOrArn
         */
        default SqsEndpointBuilder awsSqs(String componentName, String path) {
            return SqsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SqsEndpointBuilder endpointBuilder(String componentName, String path) {
        class SqsEndpointBuilderImpl extends AbstractEndpointBuilder implements SqsEndpointBuilder, AdvancedSqsEndpointBuilder {
            public SqsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SqsEndpointBuilderImpl(path);
    }
}