/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The splunk component allows to publish events in Splunk using the HTTP Event
 * Collector.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SplunkHECEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Splunk HEC component.
     */
    public interface SplunkHECEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedSplunkHECEndpointBuilder advanced() {
            return (AdvancedSplunkHECEndpointBuilder) this;
        }
        /**
         * Splunk host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default SplunkHECEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Splunk index to write to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel
         * Group: producer
         */
        default SplunkHECEndpointBuilder index(String index) {
            doSetProperty("index", index);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SplunkHECEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default SplunkHECEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Splunk source argument.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel
         * Group: producer
         */
        default SplunkHECEndpointBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * Splunk sourcetype argument.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: camel
         * Group: producer
         */
        default SplunkHECEndpointBuilder sourceType(String sourceType) {
            doSetProperty("sourceType", sourceType);
            return this;
        }
        /**
         * Contact HEC over https.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         */
        default SplunkHECEndpointBuilder https(boolean https) {
            doSetProperty("https", https);
            return this;
        }
        /**
         * Contact HEC over https.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: security
         */
        default SplunkHECEndpointBuilder https(String https) {
            doSetProperty("https", https);
            return this;
        }
        /**
         * Splunk HEC TLS verification.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SplunkHECEndpointBuilder skipTlsVerify(boolean skipTlsVerify) {
            doSetProperty("skipTlsVerify", skipTlsVerify);
            return this;
        }
        /**
         * Splunk HEC TLS verification.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default SplunkHECEndpointBuilder skipTlsVerify(String skipTlsVerify) {
            doSetProperty("skipTlsVerify", skipTlsVerify);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Splunk HEC component.
     */
    public interface AdvancedSplunkHECEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SplunkHECEndpointBuilder basic() {
            return (SplunkHECEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSplunkHECEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedSplunkHECEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface SplunkHECBuilders {
        /**
         * Splunk HEC (camel-splunk-hec)
         * The splunk component allows to publish events in Splunk using the
         * HTTP Event Collector.
         * 
         * Category: log,monitoring
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-splunk-hec
         * 
         * Syntax: <code>splunk-hec:splunkURL/token</code>
         * 
         * Path parameter: splunkURL (required)
         * Splunk Host URL
         * 
         * Path parameter: token (required)
         * Splunk authorization token
         * 
         * @param path splunkURL/token
         */
        default SplunkHECEndpointBuilder splunkHec(String path) {
            return SplunkHECEndpointBuilderFactory.endpointBuilder("splunk-hec", path);
        }
        /**
         * Splunk HEC (camel-splunk-hec)
         * The splunk component allows to publish events in Splunk using the
         * HTTP Event Collector.
         * 
         * Category: log,monitoring
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-splunk-hec
         * 
         * Syntax: <code>splunk-hec:splunkURL/token</code>
         * 
         * Path parameter: splunkURL (required)
         * Splunk Host URL
         * 
         * Path parameter: token (required)
         * Splunk authorization token
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path splunkURL/token
         */
        default SplunkHECEndpointBuilder splunkHec(
                String componentName,
                String path) {
            return SplunkHECEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SplunkHECEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class SplunkHECEndpointBuilderImpl extends AbstractEndpointBuilder implements SplunkHECEndpointBuilder, AdvancedSplunkHECEndpointBuilder {
            public SplunkHECEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SplunkHECEndpointBuilderImpl(path);
    }
}