/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Expose REST endpoints and access external REST servers.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ResteasyEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Resteasy component.
     */
    public interface ResteasyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedResteasyEndpointConsumerBuilder advanced() {
            return (AdvancedResteasyEndpointConsumerBuilder) this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Sets the resteasy method to process the request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: GET
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder resteasyMethod(
                String resteasyMethod) {
            doSetProperty("resteasyMethod", resteasyMethod);
            return this;
        }
        /**
         * Sets the servlet name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder servletName(String servletName) {
            doSetProperty("servletName", servletName);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder async(boolean async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder async(String async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Used to only allow consuming if the HttpMethod matches, such as
         * GET/POST/PUT etc. Multiple methods can be specified separated by
         * comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder httpMethodRestrict(
                String httpMethodRestrict) {
            doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder matchOnUriPrefix(
                boolean matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder matchOnUriPrefix(
                String matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder muteException(
                boolean muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder muteException(
                String muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * To use a custom buffer size on the javax.servlet.ServletResponse.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder responseBufferSize(
                Integer responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * To use a custom buffer size on the javax.servlet.ServletResponse.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default ResteasyEndpointConsumerBuilder responseBufferSize(
                String responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * Sets the resteasy proxyClientClass.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default ResteasyEndpointConsumerBuilder proxyClientClass(
                String proxyClientClass) {
            doSetProperty("proxyClientClass", proxyClientClass);
            return this;
        }
        /**
         * Sets the password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Resteasy component.
     */
    public interface AdvancedResteasyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ResteasyEndpointConsumerBuilder basic() {
            return (ResteasyEndpointConsumerBuilder) this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder eagerCheckContentAvailable(
                boolean eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder eagerCheckContentAvailable(
                String eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder optionsEnabled(
                boolean optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder optionsEnabled(
                String optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder traceEnabled(
                boolean traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         */
        default AdvancedResteasyEndpointConsumerBuilder traceEnabled(
                String traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder setHttpResponseDuringProcessing(
                Boolean setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder setHttpResponseDuringProcessing(
                String setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder skipServletProcessing(
                Boolean skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder skipServletProcessing(
                String skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder useSystemProperties(
                boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointConsumerBuilder useSystemProperties(
                String useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Resteasy component.
     */
    public interface ResteasyEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedResteasyEndpointProducerBuilder advanced() {
            return (AdvancedResteasyEndpointProducerBuilder) this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointProducerBuilder chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointProducerBuilder chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointProducerBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointProducerBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Sets the resteasy method to process the request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: GET
         * Group: common
         */
        default ResteasyEndpointProducerBuilder resteasyMethod(
                String resteasyMethod) {
            doSetProperty("resteasyMethod", resteasyMethod);
            return this;
        }
        /**
         * Sets the servlet name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ResteasyEndpointProducerBuilder servletName(String servletName) {
            doSetProperty("servletName", servletName);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder bridgeEndpoint(
                boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, HttpProducer will ignore the Exchange.HTTP_URI
         * header, and use the endpoint's URI for request. You may also set the
         * option throwExceptionOnFailure to be false to let the HttpProducer
         * send all the fault response back.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder bridgeEndpoint(
                String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder clearExpiredCookies(
                boolean clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Whether to clear expired cookies before sending the HTTP request.
         * This ensures the cookies store does not keep growing by adding new
         * cookies which is newer removed when they are expired.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder clearExpiredCookies(
                String clearExpiredCookies) {
            doSetProperty("clearExpiredCookies", clearExpiredCookies);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder connectionClose(
                boolean connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Specifies whether a Connection Close header must be added to HTTP
         * Request. By default connectionClose is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder connectionClose(
                String connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder copyHeaders(boolean copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder copyHeaders(String copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * To use custom host header for producer. When not set in query will be
         * ignored. When set will override host header derived from url.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder customHostHeader(
                String customHostHeader) {
            doSetProperty("customHostHeader", customHostHeader);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder httpMethod(
                HttpMethods httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * Configure the HTTP method to use. The HttpMethod header cannot
         * override this option if set.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.HttpMethods</code> type.
         * 
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder httpMethod(String httpMethod) {
            doSetProperty("httpMethod", httpMethod);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder ignoreResponseBody(
                boolean ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * If this option is true, The http producer won't read response body
         * and cache the input stream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder ignoreResponseBody(
                String ignoreResponseBody) {
            doSetProperty("ignoreResponseBody", ignoreResponseBody);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder preserveHostHeader(
                boolean preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * If the option is true, HttpProducer will set the Host header to the
         * value contained in the current exchange Host header, useful in
         * reverse proxy applications where you want the Host header received by
         * the downstream server to reflect the URL called by the upstream
         * client, this allows applications which use the Host header to
         * generate accurate URL's for a proxied service.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder preserveHostHeader(
                String preserveHostHeader) {
            doSetProperty("preserveHostHeader", preserveHostHeader);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default ResteasyEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Sets the resteasy proxyClientClass.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default ResteasyEndpointProducerBuilder proxyClientClass(
                String proxyClientClass) {
            doSetProperty("proxyClientClass", proxyClientClass);
            return this;
        }
        /**
         * Sets the password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Resteasy component.
     */
    public interface AdvancedResteasyEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ResteasyEndpointProducerBuilder basic() {
            return (ResteasyEndpointProducerBuilder) this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder cookieHandler(
                Object cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder cookieHandler(
                String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder deleteWithBody(
                boolean deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether the HTTP DELETE should include the message body or not. By
         * default HTTP DELETE do not include any HTTP body. However in some
         * rare cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder deleteWithBody(
                String deleteWithBody) {
            doSetProperty("deleteWithBody", deleteWithBody);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder getWithBody(
                boolean getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * Whether the HTTP GET should include the message body or not. By
         * default HTTP GET do not include any HTTP body. However in some rare
         * cases users may need to be able to include the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder getWithBody(
                String getWithBody) {
            doSetProperty("getWithBody", getWithBody);
            return this;
        }
        /**
         * The status codes which are considered a success response. The values
         * are inclusive. Multiple ranges can be defined, separated by comma,
         * e.g. 200-204,209,301-304. Each range must be a single number or
         * from-to with the dash included.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 200-299
         * Group: producer (advanced)
         */
        default AdvancedResteasyEndpointProducerBuilder okStatusCodeRange(
                String okStatusCodeRange) {
            doSetProperty("okStatusCodeRange", okStatusCodeRange);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder setHttpResponseDuringProcessing(
                Boolean setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder setHttpResponseDuringProcessing(
                String setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder skipServletProcessing(
                Boolean skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder skipServletProcessing(
                String skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder useSystemProperties(
                boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointProducerBuilder useSystemProperties(
                String useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Resteasy component.
     */
    public interface ResteasyEndpointBuilder
            extends
                ResteasyEndpointConsumerBuilder,
                ResteasyEndpointProducerBuilder {
        default AdvancedResteasyEndpointBuilder advanced() {
            return (AdvancedResteasyEndpointBuilder) this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointBuilder chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default ResteasyEndpointBuilder chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Sets the resteasy method to process the request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: GET
         * Group: common
         */
        default ResteasyEndpointBuilder resteasyMethod(String resteasyMethod) {
            doSetProperty("resteasyMethod", resteasyMethod);
            return this;
        }
        /**
         * Sets the servlet name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ResteasyEndpointBuilder servletName(String servletName) {
            doSetProperty("servletName", servletName);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ResteasyEndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Sets the resteasy proxyClientClass.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default ResteasyEndpointBuilder proxyClientClass(String proxyClientClass) {
            doSetProperty("proxyClientClass", proxyClientClass);
            return this;
        }
        /**
         * Sets the password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ResteasyEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Resteasy component.
     */
    public interface AdvancedResteasyEndpointBuilder
            extends
                AdvancedResteasyEndpointConsumerBuilder,
                AdvancedResteasyEndpointProducerBuilder {
        default ResteasyEndpointBuilder basic() {
            return (ResteasyEndpointBuilder) this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder setHttpResponseDuringProcessing(
                Boolean setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use the endpoint where you can either populate camel
         * exchange from servlet response or use request itself which may be
         * thought as if it is a proxy.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder setHttpResponseDuringProcessing(
                String setHttpResponseDuringProcessing) {
            doSetProperty("setHttpResponseDuringProcessing", setHttpResponseDuringProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder skipServletProcessing(
                Boolean skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets the flag to use skip servlet processing and let camel take over
         * processing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder skipServletProcessing(
                String skipServletProcessing) {
            doSetProperty("skipServletProcessing", skipServletProcessing);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder useSystemProperties(
                boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
        /**
         * To use System Properties as fallback for configuration.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedResteasyEndpointBuilder useSystemProperties(
                String useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    }

    /**
     * Proxy enum for <code>org.apache.camel.http.common.HttpMethods</code>
     * enum.
     */
    enum HttpMethods {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        PATCH;
    }

    public interface ResteasyBuilders {
        /**
         * Resteasy (camel-resteasy)
         * Expose REST endpoints and access external REST servers.
         * 
         * Category: rest
         * Since: 3.4
         * Maven coordinates: org.apache.camel:camel-resteasy
         * 
         * Syntax: <code>resteasy:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         */
        default ResteasyEndpointBuilder resteasy(String path) {
            return ResteasyEndpointBuilderFactory.endpointBuilder("resteasy", path);
        }
        /**
         * Resteasy (camel-resteasy)
         * Expose REST endpoints and access external REST servers.
         * 
         * Category: rest
         * Since: 3.4
         * Maven coordinates: org.apache.camel:camel-resteasy
         * 
         * Syntax: <code>resteasy:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         */
        default ResteasyEndpointBuilder resteasy(
                String componentName,
                String path) {
            return ResteasyEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ResteasyEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ResteasyEndpointBuilderImpl extends AbstractEndpointBuilder implements ResteasyEndpointBuilder, AdvancedResteasyEndpointBuilder {
            public ResteasyEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ResteasyEndpointBuilderImpl(path);
    }
}