/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Harvest metadata using OAI-PMH protocol
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OAIPMHEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the OAI-PMH component.
     */
    public interface OAIPMHEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOAIPMHEndpointConsumerBuilder advanced() {
            return (AdvancedOAIPMHEndpointConsumerBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: oai_dc
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder metadataPrefix(
                String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ListRecords
         * Group: common
         */
        default OAIPMHEndpointConsumerBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default OAIPMHEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default OAIPMHEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default OAIPMHEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default OAIPMHEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default OAIPMHEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointConsumerBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointConsumerBuilder ignoreSSLWarnings(
                String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointConsumerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointConsumerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default OAIPMHEndpointConsumerBuilder basic() {
            return (OAIPMHEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedOAIPMHEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the OAI-PMH component.
     */
    public interface OAIPMHEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOAIPMHEndpointProducerBuilder advanced() {
            return (AdvancedOAIPMHEndpointProducerBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: oai_dc
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder metadataPrefix(
                String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ListRecords
         * Group: common
         */
        default OAIPMHEndpointProducerBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default OAIPMHEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default OAIPMHEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Returns the response of a single request. Otherwise it will make
         * requests until there is no more data to return.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default OAIPMHEndpointProducerBuilder onlyFirst(boolean onlyFirst) {
            doSetProperty("onlyFirst", onlyFirst);
            return this;
        }
        /**
         * Returns the response of a single request. Otherwise it will make
         * requests until there is no more data to return.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default OAIPMHEndpointProducerBuilder onlyFirst(String onlyFirst) {
            doSetProperty("onlyFirst", onlyFirst);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointProducerBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointProducerBuilder ignoreSSLWarnings(
                String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointProducerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointProducerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default OAIPMHEndpointProducerBuilder basic() {
            return (OAIPMHEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the OAI-PMH component.
     */
    public interface OAIPMHEndpointBuilder
            extends
                OAIPMHEndpointConsumerBuilder,
                OAIPMHEndpointProducerBuilder {
        default AdvancedOAIPMHEndpointBuilder advanced() {
            return (AdvancedOAIPMHEndpointBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: oai_dc
         * Group: common
         */
        default OAIPMHEndpointBuilder metadataPrefix(String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default OAIPMHEndpointBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: ListRecords
         * Group: common
         */
        default OAIPMHEndpointBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointBuilder ignoreSSLWarnings(String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default OAIPMHEndpointBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointBuilder
            extends
                AdvancedOAIPMHEndpointConsumerBuilder,
                AdvancedOAIPMHEndpointProducerBuilder {
        default OAIPMHEndpointBuilder basic() {
            return (OAIPMHEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedOAIPMHEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface OAIPMHBuilders {
        /**
         * OAI-PMH (camel-oaipmh)
         * Harvest metadata using OAI-PMH protocol
         * 
         * Category: endpoint,webservice,batch
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-oaipmh
         * 
         * Syntax: <code>oaipmh:baseUrl</code>
         * 
         * Path parameter: baseUrl (required)
         * Base URL of the repository to which the request is made through the
         * OAI-PMH protocol
         * 
         * @param path baseUrl
         */
        default OAIPMHEndpointBuilder oaipmh(String path) {
            return OAIPMHEndpointBuilderFactory.endpointBuilder("oaipmh", path);
        }
        /**
         * OAI-PMH (camel-oaipmh)
         * Harvest metadata using OAI-PMH protocol
         * 
         * Category: endpoint,webservice,batch
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-oaipmh
         * 
         * Syntax: <code>oaipmh:baseUrl</code>
         * 
         * Path parameter: baseUrl (required)
         * Base URL of the repository to which the request is made through the
         * OAI-PMH protocol
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path baseUrl
         */
        default OAIPMHEndpointBuilder oaipmh(String componentName, String path) {
            return OAIPMHEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static OAIPMHEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class OAIPMHEndpointBuilderImpl extends AbstractEndpointBuilder implements OAIPMHEndpointBuilder, AdvancedOAIPMHEndpointBuilder {
            public OAIPMHEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OAIPMHEndpointBuilderImpl(path);
    }
}