/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Capture changes from a MongoDB database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumMongodbEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Debezium MongoDB Connector component.
     */
    public interface DebeziumMongodbEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumMongodbEndpointBuilder advanced() {
            return (AdvancedDebeziumMongodbEndpointBuilder) this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         */
        default DebeziumMongodbEndpointBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         */
        default DebeziumMongodbEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder internalKeyConverter(
                String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder internalValueConverter(
                String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetCommitPolicy(
                String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5s
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5s
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetCommitTimeoutMs(
                String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60s
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 60s
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetFlushIntervalMs(
                String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStorage(
                String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStorageFileName(
                String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStoragePartitions(
                String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStorageReplicationFactor(
                String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMongodbEndpointBuilder offsetStorageTopic(
                String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * collection names for which changes are to be excluded.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder collectionExcludeList(
                String collectionExcludeList) {
            doSetProperty("collectionExcludeList", collectionExcludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * collection names for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder collectionIncludeList(
                String collectionIncludeList) {
            doSetProperty("collectionIncludeList", collectionIncludeList);
            return this;
        }
        /**
         * The initial delay when trying to reconnect to a primary after a
         * connection cannot be made or when no primary is available. Defaults
         * to 1 second (1000 ms).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectBackoffInitialDelayMs(
                long connectBackoffInitialDelayMs) {
            doSetProperty("connectBackoffInitialDelayMs", connectBackoffInitialDelayMs);
            return this;
        }
        /**
         * The initial delay when trying to reconnect to a primary after a
         * connection cannot be made or when no primary is available. Defaults
         * to 1 second (1000 ms).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectBackoffInitialDelayMs(
                String connectBackoffInitialDelayMs) {
            doSetProperty("connectBackoffInitialDelayMs", connectBackoffInitialDelayMs);
            return this;
        }
        /**
         * The maximum delay when trying to reconnect to a primary after a
         * connection cannot be made or when no primary is available. Defaults
         * to 120 second (120,000 ms).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2m
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectBackoffMaxDelayMs(
                long connectBackoffMaxDelayMs) {
            doSetProperty("connectBackoffMaxDelayMs", connectBackoffMaxDelayMs);
            return this;
        }
        /**
         * The maximum delay when trying to reconnect to a primary after a
         * connection cannot be made or when no primary is available. Defaults
         * to 120 second (120,000 ms).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2m
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectBackoffMaxDelayMs(
                String connectBackoffMaxDelayMs) {
            doSetProperty("connectBackoffMaxDelayMs", connectBackoffMaxDelayMs);
            return this;
        }
        /**
         * Maximum number of failed connection attempts to a replica set primary
         * before an exception occurs and task is aborted. Defaults to 16, which
         * with the defaults for 'connect.backoff.initial.delay.ms' and
         * 'connect.backoff.max.delay.ms' results in just over 20 minutes of
         * attempts before failing.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 16
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectMaxAttempts(
                int connectMaxAttempts) {
            doSetProperty("connectMaxAttempts", connectMaxAttempts);
            return this;
        }
        /**
         * Maximum number of failed connection attempts to a replica set primary
         * before an exception occurs and task is aborted. Defaults to 16, which
         * with the defaults for 'connect.backoff.initial.delay.ms' and
         * 'connect.backoff.max.delay.ms' results in just over 20 minutes of
         * attempts before failing.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 16
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder connectMaxAttempts(
                String connectMaxAttempts) {
            doSetProperty("connectMaxAttempts", connectMaxAttempts);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the database
         * names for which changes are to be excluded.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder databaseExcludeList(
                String databaseExcludeList) {
            doSetProperty("databaseExcludeList", databaseExcludeList);
            return this;
        }
        /**
         * The path to the file that will be used to record the database
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder databaseHistoryFileFilename(
                String databaseHistoryFileFilename) {
            doSetProperty("databaseHistoryFileFilename", databaseHistoryFileFilename);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the database
         * names for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder databaseIncludeList(
                String databaseIncludeList) {
            doSetProperty("databaseIncludeList", databaseIncludeList);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including:'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped;'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: fail
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder eventProcessingFailureHandlingMode(
                String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * A comma-separated list of the fully-qualified names of fields that
         * should be excluded from change event message values.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder fieldExcludeList(
                String fieldExcludeList) {
            doSetProperty("fieldExcludeList", fieldExcludeList);
            return this;
        }
        /**
         * Description is not available here, please check Debezium website for
         * corresponding key 'field.renames' description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder fieldRenames(String fieldRenames) {
            doSetProperty("fieldRenames", fieldRenames);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder heartbeatIntervalMs(
                String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium-heartbeat
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder heartbeatTopicsPrefix(
                String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Maximum number of threads used to perform an initial sync of the
         * collections in a replica set. Defaults to 1.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder initialSyncMaxThreads(
                int initialSyncMaxThreads) {
            doSetProperty("initialSyncMaxThreads", initialSyncMaxThreads);
            return this;
        }
        /**
         * Maximum number of threads used to perform an initial sync of the
         * collections in a replica set. Defaults to 1.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder initialSyncMaxThreads(
                String initialSyncMaxThreads) {
            doSetProperty("initialSyncMaxThreads", initialSyncMaxThreads);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8192
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8192
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Database containing user credentials.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: admin
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbAuthsource(
                String mongodbAuthsource) {
            doSetProperty("mongodbAuthsource", mongodbAuthsource);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbConnectTimeoutMs(
                int mongodbConnectTimeoutMs) {
            doSetProperty("mongodbConnectTimeoutMs", mongodbConnectTimeoutMs);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbConnectTimeoutMs(
                String mongodbConnectTimeoutMs) {
            doSetProperty("mongodbConnectTimeoutMs", mongodbConnectTimeoutMs);
            return this;
        }
        /**
         * The hostname and port pairs (in the form 'host' or 'host:port') of
         * the MongoDB server(s) in the replica set.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbHosts(String mongodbHosts) {
            doSetProperty("mongodbHosts", mongodbHosts);
            return this;
        }
        /**
         * Specifies whether the addresses in 'hosts' are seeds that should be
         * used to discover all members of the cluster or replica set ('true'),
         * or whether the address(es) in 'hosts' should be used as is ('false').
         * The default is 'true'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbMembersAutoDiscover(
                boolean mongodbMembersAutoDiscover) {
            doSetProperty("mongodbMembersAutoDiscover", mongodbMembersAutoDiscover);
            return this;
        }
        /**
         * Specifies whether the addresses in 'hosts' are seeds that should be
         * used to discover all members of the cluster or replica set ('true'),
         * or whether the address(es) in 'hosts' should be used as is ('false').
         * The default is 'true'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbMembersAutoDiscover(
                String mongodbMembersAutoDiscover) {
            doSetProperty("mongodbMembersAutoDiscover", mongodbMembersAutoDiscover);
            return this;
        }
        /**
         * Unique name that identifies the MongoDB replica set or cluster and
         * all recorded offsets, andthat is used as a prefix for all schemas and
         * topics. Each distinct MongoDB installation should have a separate
         * namespace and monitored by at most one Debezium connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbName(String mongodbName) {
            doSetProperty("mongodbName", mongodbName);
            return this;
        }
        /**
         * Password to be used when connecting to MongoDB, if necessary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbPassword(
                String mongodbPassword) {
            doSetProperty("mongodbPassword", mongodbPassword);
            return this;
        }
        /**
         * Frequency in milliseconds to look for new, removed, or changed
         * replica sets. Defaults to 30000 milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbPollIntervalMs(
                long mongodbPollIntervalMs) {
            doSetProperty("mongodbPollIntervalMs", mongodbPollIntervalMs);
            return this;
        }
        /**
         * Frequency in milliseconds to look for new, removed, or changed
         * replica sets. Defaults to 30000 milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbPollIntervalMs(
                String mongodbPollIntervalMs) {
            doSetProperty("mongodbPollIntervalMs", mongodbPollIntervalMs);
            return this;
        }
        /**
         * The server selection timeout in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbServerSelectionTimeoutMs(
                int mongodbServerSelectionTimeoutMs) {
            doSetProperty("mongodbServerSelectionTimeoutMs", mongodbServerSelectionTimeoutMs);
            return this;
        }
        /**
         * The server selection timeout in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbServerSelectionTimeoutMs(
                String mongodbServerSelectionTimeoutMs) {
            doSetProperty("mongodbServerSelectionTimeoutMs", mongodbServerSelectionTimeoutMs);
            return this;
        }
        /**
         * The socket timeout in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSocketTimeoutMs(
                int mongodbSocketTimeoutMs) {
            doSetProperty("mongodbSocketTimeoutMs", mongodbSocketTimeoutMs);
            return this;
        }
        /**
         * The socket timeout in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSocketTimeoutMs(
                String mongodbSocketTimeoutMs) {
            doSetProperty("mongodbSocketTimeoutMs", mongodbSocketTimeoutMs);
            return this;
        }
        /**
         * Should connector use SSL to connect to MongoDB instances.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSslEnabled(
                boolean mongodbSslEnabled) {
            doSetProperty("mongodbSslEnabled", mongodbSslEnabled);
            return this;
        }
        /**
         * Should connector use SSL to connect to MongoDB instances.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSslEnabled(
                String mongodbSslEnabled) {
            doSetProperty("mongodbSslEnabled", mongodbSslEnabled);
            return this;
        }
        /**
         * Whether invalid host names are allowed when using SSL. If true the
         * connection will not prevent man-in-the-middle attacks.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSslInvalidHostnameAllowed(
                boolean mongodbSslInvalidHostnameAllowed) {
            doSetProperty("mongodbSslInvalidHostnameAllowed", mongodbSslInvalidHostnameAllowed);
            return this;
        }
        /**
         * Whether invalid host names are allowed when using SSL. If true the
         * connection will not prevent man-in-the-middle attacks.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbSslInvalidHostnameAllowed(
                String mongodbSslInvalidHostnameAllowed) {
            doSetProperty("mongodbSslInvalidHostnameAllowed", mongodbSslInvalidHostnameAllowed);
            return this;
        }
        /**
         * Database user for connecting to MongoDB, if necessary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder mongodbUser(String mongodbUser) {
            doSetProperty("mongodbUser", mongodbUser);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder pollIntervalMs(
                long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder pollIntervalMs(
                String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder provideTransactionMetadata(
                boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder provideTransactionMetadata(
                String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of 0 uses the default JDBC fetch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of 0 uses the default JDBC fetch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder queryFetchSize(
                String queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder retriableRestartConnectorWaitMs(
                long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder retriableRestartConnectorWaitMs(
                String retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder sanitizeFieldNames(
                boolean sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder sanitizeFieldNames(
                String sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'i' for inserts; 'u' for updates; 'd' for deletes. By
         * default, no operations will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder skippedOperations(
                String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder snapshotDelayMs(
                long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder snapshotDelayMs(
                String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder snapshotFetchSize(
                String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Options include: 'initial' (the default) to specify the connector
         * should always perform an initial sync when required; 'never' to
         * specify the connector should never perform an initial sync.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: initial
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * A version of the format of the publicly visible source part in the
         * message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: v2
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder sourceStructVersion(
                String sourceStructVersion) {
            doSetProperty("sourceStructVersion", sourceStructVersion);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         */
        default DebeziumMongodbEndpointBuilder tombstonesOnDelete(
                String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium MongoDB Connector
     * component.
     */
    public interface AdvancedDebeziumMongodbEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumMongodbEndpointBuilder basic() {
            return (DebeziumMongodbEndpointBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMongodbEndpointBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMongodbEndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMongodbEndpointBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMongodbEndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumMongodbEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumMongodbEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface DebeziumMongodbBuilders {
        /**
         * Debezium MongoDB Connector (camel-debezium-mongodb)
         * Capture changes from a MongoDB database.
         * 
         * Category: database,nosql
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-mongodb
         * 
         * Syntax: <code>debezium-mongodb:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         */
        default DebeziumMongodbEndpointBuilder debeziumMongodb(String path) {
            return DebeziumMongodbEndpointBuilderFactory.endpointBuilder("debezium-mongodb", path);
        }
        /**
         * Debezium MongoDB Connector (camel-debezium-mongodb)
         * Capture changes from a MongoDB database.
         * 
         * Category: database,nosql
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-mongodb
         * 
         * Syntax: <code>debezium-mongodb:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         */
        default DebeziumMongodbEndpointBuilder debeziumMongodb(
                String componentName,
                String path) {
            return DebeziumMongodbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static DebeziumMongodbEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DebeziumMongodbEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumMongodbEndpointBuilder, AdvancedDebeziumMongodbEndpointBuilder {
            public DebeziumMongodbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumMongodbEndpointBuilderImpl(path);
    }
}