/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.vertx.kafka.VertxKafkaComponent;

/**
 * Sent and receive messages to/from an Apache Kafka broker using vert.x Kafka
 * client
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface VertxKafkaComponentBuilderFactory {

    /**
     * Vert.x Kafka (camel-vertx-kafka)
     * Sent and receive messages to/from an Apache Kafka broker using vert.x
     * Kafka client
     * 
     * Category: messaging
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-vertx-kafka
     */
    static VertxKafkaComponentBuilder vertxKafka() {
        return new VertxKafkaComponentBuilderImpl();
    }

    /**
     * Builder for the Vert.x Kafka component.
     */
    interface VertxKafkaComponentBuilder
            extends
                ComponentBuilder<VertxKafkaComponent> {
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map<java.lang.String,
         * java.lang.Object></code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder additionalProperties(
                java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * A list of host/port pairs to use for establishing the initial
         * connection to the Kafka cluster. The client will make use of all
         * servers irrespective of which servers are specified here for
         * bootstrapping&mdash;this list only impacts the initial hosts used to
         * discover the full set of servers. This list should be in the form
         * host1:port1,host2:port2,.... Since these servers are just used for
         * the initial connection to discover the full cluster membership (which
         * may change dynamically), this list need not contain the full set of
         * servers (you may want more than one, though, in case a server is
         * down).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder bootstrapServers(
                java.lang.String bootstrapServers) {
            doSetProperty("bootstrapServers", bootstrapServers);
            return this;
        }
        /**
         * Controls how the client uses DNS lookups. If set to use_all_dns_ips,
         * connect to each returned IP address in sequence until a successful
         * connection is established. After a disconnection, the next IP is
         * used. Once all IPs have been used once, the client resolves the IP(s)
         * from the hostname again (both the JVM and the OS cache DNS name
         * lookups, however). If set to
         * resolve_canonical_bootstrap_servers_only, resolve each bootstrap
         * address into a list of canonical names. After the bootstrap phase,
         * this behaves the same as use_all_dns_ips. If set to default
         * (deprecated), attempt to connect to the first IP address returned by
         * the lookup, even if the lookup returns multiple IP addresses.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: use_all_dns_ips
         * Group: common
         */
        default VertxKafkaComponentBuilder clientDnsLookup(
                java.lang.String clientDnsLookup) {
            doSetProperty("clientDnsLookup", clientDnsLookup);
            return this;
        }
        /**
         * An id string to pass to the server when making requests. The purpose
         * of this is to be able to track the source of requests beyond just
         * ip/port by allowing a logical application name to be included in
         * server-side request logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The component configurations.
         * 
         * The option is a:
         * <code>org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder configuration(
                org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Close idle connections after the number of milliseconds specified by
         * this config.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 9m
         * Group: common
         */
        default VertxKafkaComponentBuilder connectionsMaxIdleMs(
                long connectionsMaxIdleMs) {
            doSetProperty("connectionsMaxIdleMs", connectionsMaxIdleMs);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * A list of classes to use as interceptors. Implementing the
         * org.apache.kafka.clients.producer.ProducerInterceptor interface
         * allows you to intercept (and possibly mutate) the records received by
         * the producer before they are published to the Kafka cluster. By
         * default, there are no interceptors.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder interceptorClasses(
                java.lang.String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * The period of time in milliseconds after which we force a refresh of
         * metadata even if we haven't seen any partition leadership changes to
         * proactively discover any new brokers or partitions.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5m
         * Group: common
         */
        default VertxKafkaComponentBuilder metadataMaxAgeMs(
                long metadataMaxAgeMs) {
            doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }
        /**
         * A list of classes to use as metrics reporters. Implementing the
         * org.apache.kafka.common.metrics.MetricsReporter interface allows
         * plugging in classes that will be notified of new metric creation. The
         * JmxReporter is always included to register JMX statistics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder metricReporters(
                java.lang.String metricReporters) {
            doSetProperty("metricReporters", metricReporters);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default VertxKafkaComponentBuilder metricsNumSamples(
                int metricsNumSamples) {
            doSetProperty("metricsNumSamples", metricsNumSamples);
            return this;
        }
        /**
         * The highest recording level for metrics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: INFO
         * Group: common
         */
        default VertxKafkaComponentBuilder metricsRecordingLevel(
                java.lang.String metricsRecordingLevel) {
            doSetProperty("metricsRecordingLevel", metricsRecordingLevel);
            return this;
        }
        /**
         * The window of time a metrics sample is computed over.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30s
         * Group: common
         */
        default VertxKafkaComponentBuilder metricsSampleWindowMs(
                long metricsSampleWindowMs) {
            doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }
        /**
         * The partition to which the record will be sent (or null if no
         * partition was specified) or read from a particular partition if set.
         * Header VertxKafkaConstants#PARTITION_ID If configured, it will take
         * precedence over this config.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default VertxKafkaComponentBuilder partitionId(
                java.lang.Integer partitionId) {
            doSetProperty("partitionId", partitionId);
            return this;
        }
        /**
         * The size of the TCP receive buffer (SO_RCVBUF) to use when reading
         * data. If the value is -1, the OS default will be used.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 32768
         * Group: common
         */
        default VertxKafkaComponentBuilder receiveBufferBytes(
                int receiveBufferBytes) {
            doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1s
         * Group: common
         */
        default VertxKafkaComponentBuilder reconnectBackoffMaxMs(
                long reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * The base amount of time to wait before attempting to reconnect to a
         * given host. This avoids repeatedly connecting to a host in a tight
         * loop. This backoff applies to all connection attempts by the client
         * to a broker.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 50ms
         * Group: common
         */
        default VertxKafkaComponentBuilder reconnectBackoffMs(
                long reconnectBackoffMs) {
            doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }
        /**
         * The configuration controls the maximum amount of time the client will
         * wait for the response of a request. If the response is not received
         * before the timeout elapses the client will resend the request if
         * necessary or fail the request if retries are exhausted. This should
         * be larger than replica.lag.time.max.ms (a broker configuration) to
         * reduce the possibility of message duplication due to unnecessary
         * producer retries.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30s
         * Group: common
         */
        default VertxKafkaComponentBuilder requestTimeoutMs(int requestTimeoutMs) {
            doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }
        /**
         * The amount of time to wait before attempting to retry a failed
         * request to a given topic partition. This avoids repeatedly sending
         * requests in a tight loop under some failure scenarios.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 100ms
         * Group: common
         */
        default VertxKafkaComponentBuilder retryBackoffMs(long retryBackoffMs) {
            doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }
        /**
         * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.
         * If the value is -1, the OS default will be used.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 131072
         * Group: common
         */
        default VertxKafkaComponentBuilder sendBufferBytes(int sendBufferBytes) {
            doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }
        /**
         * Allow automatic topic creation on the broker when subscribing to or
         * assigning a topic. A topic being subscribed to will be automatically
         * created only if the broker allows for it using
         * auto.create.topics.enable broker configuration. This configuration
         * must be set to false when using brokers older than 0.11.0.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default VertxKafkaComponentBuilder allowAutoCreateTopics(
                boolean allowAutoCreateTopics) {
            doSetProperty("allowAutoCreateTopics", allowAutoCreateTopics);
            return this;
        }
        /**
         * The frequency in milliseconds that the consumer offsets are
         * auto-committed to Kafka if enable.auto.commit is set to true.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5s
         * Group: consumer
         */
        default VertxKafkaComponentBuilder autoCommitIntervalMs(
                int autoCommitIntervalMs) {
            doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }
        /**
         * What to do when there is no initial offset in Kafka or if the current
         * offset does not exist any more on the server (e.g. because that data
         * has been deleted): earliest: automatically reset the offset to the
         * earliest offsetlatest: automatically reset the offset to the latest
         * offsetnone: throw exception to the consumer if no previous offset is
         * found for the consumer's groupanything else: throw exception to the
         * consumer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: consumer
         */
        default VertxKafkaComponentBuilder autoOffsetReset(
                java.lang.String autoOffsetReset) {
            doSetProperty("autoOffsetReset", autoOffsetReset);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default VertxKafkaComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Automatically check the CRC32 of the records consumed. This ensures
         * no on-the-wire or on-disk corruption to the messages occurred. This
         * check adds some overhead, so it may be disabled in cases seeking
         * extreme performance.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default VertxKafkaComponentBuilder checkCrcs(boolean checkCrcs) {
            doSetProperty("checkCrcs", checkCrcs);
            return this;
        }
        /**
         * A rack identifier for this client. This can be any string value which
         * indicates where this client is physically located. It corresponds
         * with the broker config 'broker.rack'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default VertxKafkaComponentBuilder clientRack(
                java.lang.String clientRack) {
            doSetProperty("clientRack", clientRack);
            return this;
        }
        /**
         * Specifies the timeout (in milliseconds) for client APIs. This
         * configuration is used as the default timeout for all client
         * operations that do not specify a timeout parameter.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1m
         * Group: consumer
         */
        default VertxKafkaComponentBuilder defaultApiTimeoutMs(
                int defaultApiTimeoutMs) {
            doSetProperty("defaultApiTimeoutMs", defaultApiTimeoutMs);
            return this;
        }
        /**
         * If true the consumer's offset will be periodically committed in the
         * background.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default VertxKafkaComponentBuilder enableAutoCommit(
                boolean enableAutoCommit) {
            doSetProperty("enableAutoCommit", enableAutoCommit);
            return this;
        }
        /**
         * Whether internal topics matching a subscribed pattern should be
         * excluded from the subscription. It is always possible to explicitly
         * subscribe to an internal topic.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default VertxKafkaComponentBuilder excludeInternalTopics(
                boolean excludeInternalTopics) {
            doSetProperty("excludeInternalTopics", excludeInternalTopics);
            return this;
        }
        /**
         * The maximum amount of data the server should return for a fetch
         * request. Records are fetched in batches by the consumer, and if the
         * first record batch in the first non-empty partition of the fetch is
         * larger than this value, the record batch will still be returned to
         * ensure that the consumer can make progress. As such, this is not a
         * absolute maximum. The maximum record batch size accepted by the
         * broker is defined via message.max.bytes (broker config) or
         * max.message.bytes (topic config). Note that the consumer performs
         * multiple fetches in parallel.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 52428800
         * Group: consumer
         */
        default VertxKafkaComponentBuilder fetchMaxBytes(int fetchMaxBytes) {
            doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }
        /**
         * The maximum amount of time the server will block before answering the
         * fetch request if there isn't sufficient data to immediately satisfy
         * the requirement given by fetch.min.bytes.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500ms
         * Group: consumer
         */
        default VertxKafkaComponentBuilder fetchMaxWaitMs(int fetchMaxWaitMs) {
            doSetProperty("fetchMaxWaitMs", fetchMaxWaitMs);
            return this;
        }
        /**
         * The minimum amount of data the server should return for a fetch
         * request. If insufficient data is available the request will wait for
         * that much data to accumulate before answering the request. The
         * default setting of 1 byte means that fetch requests are answered as
         * soon as a single byte of data is available or the fetch request times
         * out waiting for data to arrive. Setting this to something greater
         * than 1 will cause the server to wait for larger amounts of data to
         * accumulate which can improve server throughput a bit at the cost of
         * some additional latency.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default VertxKafkaComponentBuilder fetchMinBytes(int fetchMinBytes) {
            doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }
        /**
         * A unique string that identifies the consumer group this consumer
         * belongs to. This property is required if the consumer uses either the
         * group management functionality by using subscribe(topic) or the
         * Kafka-based offset management strategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default VertxKafkaComponentBuilder groupId(java.lang.String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * A unique identifier of the consumer instance provided by the end
         * user. Only non-empty strings are permitted. If set, the consumer is
         * treated as a static member, which means that only one instance with
         * this ID is allowed in the consumer group at any time. This can be
         * used in combination with a larger session timeout to avoid group
         * rebalances caused by transient unavailability (e.g. process
         * restarts). If not set, the consumer will join the group as a dynamic
         * member, which is the traditional behavior.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default VertxKafkaComponentBuilder groupInstanceId(
                java.lang.String groupInstanceId) {
            doSetProperty("groupInstanceId", groupInstanceId);
            return this;
        }
        /**
         * The expected time between heartbeats to the consumer coordinator when
         * using Kafka's group management facilities. Heartbeats are used to
         * ensure that the consumer's session stays active and to facilitate
         * rebalancing when new consumers join or leave the group. The value
         * must be set lower than session.timeout.ms, but typically should be
         * set no higher than 1/3 of that value. It can be adjusted even lower
         * to control the expected time for normal rebalances.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 3s
         * Group: consumer
         */
        default VertxKafkaComponentBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Controls how to read messages written transactionally. If set to
         * read_committed, consumer.poll() will only return transactional
         * messages which have been committed. If set to read_uncommitted' (the
         * default), consumer.poll() will return all messages, even
         * transactional messages which have been aborted. Non-transactional
         * messages will be returned unconditionally in either mode. Messages
         * will always be returned in offset order. Hence, in read_committed
         * mode, consumer.poll() will only return messages up to the last stable
         * offset (LSO), which is the one less than the offset of the first open
         * transaction. In particular any messages appearing after messages
         * belonging to ongoing transactions will be withheld until the relevant
         * transaction has been completed. As a result, read_committed consumers
         * will not be able to read up to the high watermark when there are in
         * flight transactions. Further, when in read_committed the seekToEnd
         * method will return the LSO.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: read_uncommitted
         * Group: consumer
         */
        default VertxKafkaComponentBuilder isolationLevel(
                java.lang.String isolationLevel) {
            doSetProperty("isolationLevel", isolationLevel);
            return this;
        }
        /**
         * Deserializer class for key that implements the
         * org.apache.kafka.common.serialization.Deserializer interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         */
        default VertxKafkaComponentBuilder keyDeserializer(
                java.lang.String keyDeserializer) {
            doSetProperty("keyDeserializer", keyDeserializer);
            return this;
        }
        /**
         * The maximum amount of data per-partition the server will return.
         * Records are fetched in batches by the consumer. If the first record
         * batch in the first non-empty partition of the fetch is larger than
         * this limit, the batch will still be returned to ensure that the
         * consumer can make progress. The maximum record batch size accepted by
         * the broker is defined via message.max.bytes (broker config) or
         * max.message.bytes (topic config). See fetch.max.bytes for limiting
         * the consumer request size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1048576
         * Group: consumer
         */
        default VertxKafkaComponentBuilder maxPartitionFetchBytes(
                int maxPartitionFetchBytes) {
            doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }
        /**
         * The maximum delay between invocations of poll() when using consumer
         * group management. This places an upper bound on the amount of time
         * that the consumer can be idle before fetching more records. If poll()
         * is not called before expiration of this timeout, then the consumer is
         * considered failed and the group will rebalance in order to reassign
         * the partitions to another member. For consumers using a non-null
         * group.instance.id which reach this timeout, partitions will not be
         * immediately reassigned. Instead, the consumer will stop sending
         * heartbeats and partitions will be reassigned after expiration of
         * session.timeout.ms. This mirrors the behavior of a static consumer
         * which has shutdown.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5m
         * Group: consumer
         */
        default VertxKafkaComponentBuilder maxPollIntervalMs(
                int maxPollIntervalMs) {
            doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }
        /**
         * The maximum number of records returned in a single call to poll().
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: consumer
         */
        default VertxKafkaComponentBuilder maxPollRecords(int maxPollRecords) {
            doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }
        /**
         * A list of class names or class types, ordered by preference, of
         * supported partition assignment strategies that the client will use to
         * distribute partition ownership amongst consumer instances when group
         * management is used.In addition to the default class specified below,
         * you can use the
         * org.apache.kafka.clients.consumer.RoundRobinAssignorclass for round
         * robin assignments of partitions to consumers. Implementing the
         * org.apache.kafka.clients.consumer.ConsumerPartitionAssignor interface
         * allows you to plug in a custom assignmentstrategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.clients.consumer.RangeAssignor
         * Group: consumer
         */
        default VertxKafkaComponentBuilder partitionAssignmentStrategy(
                java.lang.String partitionAssignmentStrategy) {
            doSetProperty("partitionAssignmentStrategy", partitionAssignmentStrategy);
            return this;
        }
        /**
         * Set if KafkaConsumer will read from a particular offset on startup.
         * This config will take precedence over seekTo config.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default VertxKafkaComponentBuilder seekToOffset(
                java.lang.Long seekToOffset) {
            doSetProperty("seekToOffset", seekToOffset);
            return this;
        }
        /**
         * Set if KafkaConsumer will read from beginning or end on startup:
         * beginning : read from beginning end : read from end.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default VertxKafkaComponentBuilder seekToPosition(
                java.lang.String seekToPosition) {
            doSetProperty("seekToPosition", seekToPosition);
            return this;
        }
        /**
         * The timeout used to detect client failures when using Kafka's group
         * management facility. The client sends periodic heartbeats to indicate
         * its liveness to the broker. If no heartbeats are received by the
         * broker before the expiration of this session timeout, then the broker
         * will remove this client from the group and initiate a rebalance. Note
         * that the value must be in the allowable range as configured in the
         * broker configuration by group.min.session.timeout.ms and
         * group.max.session.timeout.ms.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10s
         * Group: consumer
         */
        default VertxKafkaComponentBuilder sessionTimeoutMs(int sessionTimeoutMs) {
            doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }
        /**
         * Deserializer class for value that implements the
         * org.apache.kafka.common.serialization.Deserializer interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         */
        default VertxKafkaComponentBuilder valueDeserializer(
                java.lang.String valueDeserializer) {
            doSetProperty("valueDeserializer", valueDeserializer);
            return this;
        }
        /**
         * The number of acknowledgments the producer requires the leader to
         * have received before considering a request complete. This controls
         * the durability of records that are sent. The following settings are
         * allowed: acks=0 If set to zero then the producer will not wait for
         * any acknowledgment from the server at all. The record will be
         * immediately added to the socket buffer and considered sent. No
         * guarantee can be made that the server has received the record in this
         * case, and the retries configuration will not take effect (as the
         * client won't generally know of any failures). The offset given back
         * for each record will always be set to -1. acks=1 This will mean the
         * leader will write the record to its local log but will respond
         * without awaiting full acknowledgement from all followers. In this
         * case should the leader fail immediately after acknowledging the
         * record but before the followers have replicated it then the record
         * will be lost. acks=all This means the leader will wait for the full
         * set of in-sync replicas to acknowledge the record. This guarantees
         * that the record will not be lost as long as at least one in-sync
         * replica remains alive. This is the strongest available guarantee.
         * This is equivalent to the acks=-1 setting.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1
         * Group: producer
         */
        default VertxKafkaComponentBuilder acks(java.lang.String acks) {
            doSetProperty("acks", acks);
            return this;
        }
        /**
         * The producer will attempt to batch records together into fewer
         * requests whenever multiple records are being sent to the same
         * partition. This helps performance on both the client and the server.
         * This configuration controls the default batch size in bytes. No
         * attempt will be made to batch records larger than this size. Requests
         * sent to brokers will contain multiple batches, one for each partition
         * with data available to be sent. A small batch size will make batching
         * less common and may reduce throughput (a batch size of zero will
         * disable batching entirely). A very large batch size may use memory a
         * bit more wastefully as we will always allocate a buffer of the
         * specified batch size in anticipation of additional records.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 16384
         * Group: producer
         */
        default VertxKafkaComponentBuilder batchSize(int batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
        /**
         * The total bytes of memory the producer can use to buffer records
         * waiting to be sent to the server. If records are sent faster than
         * they can be delivered to the server the producer will block for
         * max.block.ms after which it will throw an exception.This setting
         * should correspond roughly to the total memory the producer will use,
         * but is not a hard bound since not all memory the producer uses is
         * used for buffering. Some additional memory will be used for
         * compression (if compression is enabled) as well as for maintaining
         * in-flight requests.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 33554432
         * Group: producer
         */
        default VertxKafkaComponentBuilder bufferMemory(long bufferMemory) {
            doSetProperty("bufferMemory", bufferMemory);
            return this;
        }
        /**
         * The compression type for all data generated by the producer. The
         * default is none (i.e. no compression). Valid values are none, gzip,
         * snappy, lz4, or zstd. Compression is of full batches of data, so the
         * efficacy of batching will also impact the compression ratio (more
         * batching means better compression).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: producer
         */
        default VertxKafkaComponentBuilder compressionType(
                java.lang.String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * An upper bound on the time to report success or failure after a call
         * to send() returns. This limits the total time that a record will be
         * delayed prior to sending, the time to await acknowledgement from the
         * broker (if expected), and the time allowed for retriable send
         * failures. The producer may report failure to send a record earlier
         * than this config if either an unrecoverable error is encountered, the
         * retries have been exhausted, or the record is added to a batch which
         * reached an earlier delivery expiration deadline. The value of this
         * config should be greater than or equal to the sum of
         * request.timeout.ms and linger.ms.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2m
         * Group: producer
         */
        default VertxKafkaComponentBuilder deliveryTimeoutMs(
                int deliveryTimeoutMs) {
            doSetProperty("deliveryTimeoutMs", deliveryTimeoutMs);
            return this;
        }
        /**
         * When set to 'true', the producer will ensure that exactly one copy of
         * each message is written in the stream. If 'false', producer retries
         * due to broker failures, etc., may write duplicates of the retried
         * message in the stream. Note that enabling idempotence requires
         * max.in.flight.requests.per.connection to be less than or equal to 5,
         * retries to be greater than 0 and acks must be 'all'. If these values
         * are not explicitly set by the user, suitable values will be chosen.
         * If incompatible values are set, a ConfigException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default VertxKafkaComponentBuilder enableIdempotence(
                boolean enableIdempotence) {
            doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }
        /**
         * Serializer class for key that implements the
         * org.apache.kafka.common.serialization.Serializer interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         */
        default VertxKafkaComponentBuilder keySerializer(
                java.lang.String keySerializer) {
            doSetProperty("keySerializer", keySerializer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default VertxKafkaComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The producer groups together any records that arrive in between
         * request transmissions into a single batched request. Normally this
         * occurs only under load when records arrive faster than they can be
         * sent out. However in some circumstances the client may want to reduce
         * the number of requests even under moderate load. This setting
         * accomplishes this by adding a small amount of artificial
         * delay&mdash;that is, rather than immediately sending out a record the
         * producer will wait for up to the given delay to allow other records
         * to be sent so that the sends can be batched together. This can be
         * thought of as analogous to Nagle's algorithm in TCP. This setting
         * gives the upper bound on the delay for batching: once we get
         * batch.size worth of records for a partition it will be sent
         * immediately regardless of this setting, however if we have fewer than
         * this many bytes accumulated for this partition we will 'linger' for
         * the specified time waiting for more records to show up. This setting
         * defaults to 0 (i.e. no delay). Setting linger.ms=5, for example,
         * would have the effect of reducing the number of requests sent but
         * would add up to 5ms of latency to records sent in the absence of
         * load.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: producer
         */
        default VertxKafkaComponentBuilder lingerMs(long lingerMs) {
            doSetProperty("lingerMs", lingerMs);
            return this;
        }
        /**
         * The configuration controls how long KafkaProducer.send() and
         * KafkaProducer.partitionsFor() will block.These methods can be blocked
         * either because the buffer is full or metadata unavailable.Blocking in
         * the user-supplied serializers or partitioner will not be counted
         * against this timeout.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1m
         * Group: producer
         */
        default VertxKafkaComponentBuilder maxBlockMs(long maxBlockMs) {
            doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }
        /**
         * The maximum number of unacknowledged requests the client will send on
         * a single connection before blocking. Note that if this setting is set
         * to be greater than 1 and there are failed sends, there is a risk of
         * message re-ordering due to retries (i.e., if retries are enabled).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5
         * Group: producer
         */
        default VertxKafkaComponentBuilder maxInFlightRequestsPerConnection(
                int maxInFlightRequestsPerConnection) {
            doSetProperty("maxInFlightRequestsPerConnection", maxInFlightRequestsPerConnection);
            return this;
        }
        /**
         * The maximum size of a request in bytes. This setting will limit the
         * number of record batches the producer will send in a single request
         * to avoid sending huge requests. This is also effectively a cap on the
         * maximum uncompressed record batch size. Note that the server has its
         * own cap on the record batch size (after compression if compression is
         * enabled) which may be different from this.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1048576
         * Group: producer
         */
        default VertxKafkaComponentBuilder maxRequestSize(int maxRequestSize) {
            doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }
        /**
         * Controls how long the producer will cache metadata for a topic that's
         * idle. If the elapsed time since a topic was last produced to exceeds
         * the metadata idle duration, then the topic's metadata is forgotten
         * and the next access to it will force a metadata fetch request.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5m
         * Group: producer
         */
        default VertxKafkaComponentBuilder metadataMaxIdleMs(
                long metadataMaxIdleMs) {
            doSetProperty("metadataMaxIdleMs", metadataMaxIdleMs);
            return this;
        }
        /**
         * Partitioner class that implements the
         * org.apache.kafka.clients.producer.Partitioner interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * org.apache.kafka.clients.producer.internals.DefaultPartitioner
         * Group: producer
         */
        default VertxKafkaComponentBuilder partitionerClass(
                java.lang.String partitionerClass) {
            doSetProperty("partitionerClass", partitionerClass);
            return this;
        }
        /**
         * Setting a value greater than zero will cause the client to resend any
         * record whose send fails with a potentially transient error. Note that
         * this retry is no different than if the client resent the record upon
         * receiving the error. Allowing retries without setting
         * max.in.flight.requests.per.connection to 1 will potentially change
         * the ordering of records because if two batches are sent to a single
         * partition, and the first fails and is retried but the second
         * succeeds, then the records in the second batch may appear first. Note
         * additionally that produce requests will be failed before the number
         * of retries has been exhausted if the timeout configured by
         * delivery.timeout.ms expires first before successful acknowledgement.
         * Users should generally prefer to leave this config unset and instead
         * use delivery.timeout.ms to control retry behavior.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2147483647
         * Group: producer
         */
        default VertxKafkaComponentBuilder retries(int retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * The TransactionalId to use for transactional delivery. This enables
         * reliability semantics which span multiple producer sessions since it
         * allows the client to guarantee that transactions using the same
         * TransactionalId have been completed prior to starting any new
         * transactions. If no TransactionalId is provided, then the producer is
         * limited to idempotent delivery. If a TransactionalId is configured,
         * enable.idempotence is implied. By default the TransactionId is not
         * configured, which means transactions cannot be used. Note that, by
         * default, transactions require a cluster of at least three brokers
         * which is the recommended setting for production; for development you
         * can change this, by adjusting broker setting
         * transaction.state.log.replication.factor.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default VertxKafkaComponentBuilder transactionalId(
                java.lang.String transactionalId) {
            doSetProperty("transactionalId", transactionalId);
            return this;
        }
        /**
         * The maximum amount of time in ms that the transaction coordinator
         * will wait for a transaction status update from the producer before
         * proactively aborting the ongoing transaction.If this value is larger
         * than the transaction.max.timeout.ms setting in the broker, the
         * request will fail with a InvalidTransactionTimeout error.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1m
         * Group: producer
         */
        default VertxKafkaComponentBuilder transactionTimeoutMs(
                int transactionTimeoutMs) {
            doSetProperty("transactionTimeoutMs", transactionTimeoutMs);
            return this;
        }
        /**
         * Serializer class for value that implements the
         * org.apache.kafka.common.serialization.Serializer interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         */
        default VertxKafkaComponentBuilder valueSerializer(
                java.lang.String valueSerializer) {
            doSetProperty("valueSerializer", valueSerializer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default VertxKafkaComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * To use an existing vertx instead of creating a new instance.
         * 
         * The option is a: <code>io.vertx.core.Vertx</code> type.
         * 
         * Group: advanced
         */
        default VertxKafkaComponentBuilder vertx(io.vertx.core.Vertx vertx) {
            doSetProperty("vertx", vertx);
            return this;
        }
        /**
         * To provide a custom set of vertx options for configuring vertx.
         * 
         * The option is a: <code>io.vertx.core.VertxOptions</code> type.
         * 
         * Group: advanced
         */
        default VertxKafkaComponentBuilder vertxOptions(
                io.vertx.core.VertxOptions vertxOptions) {
            doSetProperty("vertxOptions", vertxOptions);
            return this;
        }
        /**
         * The fully qualified name of a SASL client callback handler class that
         * implements the AuthenticateCallbackHandler interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder saslClientCallbackHandlerClass(
                java.lang.String saslClientCallbackHandlerClass) {
            doSetProperty("saslClientCallbackHandlerClass", saslClientCallbackHandlerClass);
            return this;
        }
        /**
         * JAAS login context parameters for SASL connections in the format used
         * by JAAS configuration files. JAAS configuration file format is
         * described here. The format for the value is: 'loginModuleClass
         * controlFlag (optionName=optionValue);'. For brokers, the config must
         * be prefixed with listener prefix and SASL mechanism name in
         * lower-case. For example,
         * listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder saslJaasConfig(
                java.lang.String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * Kerberos kinit command path.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         */
        default VertxKafkaComponentBuilder saslKerberosKinitCmd(
                java.lang.String saslKerberosKinitCmd) {
            doSetProperty("saslKerberosKinitCmd", saslKerberosKinitCmd);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60000
         * Group: security
         */
        default VertxKafkaComponentBuilder saslKerberosMinTimeBeforeRelogin(
                long saslKerberosMinTimeBeforeRelogin) {
            doSetProperty("saslKerberosMinTimeBeforeRelogin", saslKerberosMinTimeBeforeRelogin);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder saslKerberosServiceName(
                java.lang.String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.05
         * Group: security
         */
        default VertxKafkaComponentBuilder saslKerberosTicketRenewJitter(
                double saslKerberosTicketRenewJitter) {
            doSetProperty("saslKerberosTicketRenewJitter", saslKerberosTicketRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.8
         * Group: security
         */
        default VertxKafkaComponentBuilder saslKerberosTicketRenewWindowFactor(
                double saslKerberosTicketRenewWindowFactor) {
            doSetProperty("saslKerberosTicketRenewWindowFactor", saslKerberosTicketRenewWindowFactor);
            return this;
        }
        /**
         * The fully qualified name of a SASL login callback handler class that
         * implements the AuthenticateCallbackHandler interface. For brokers,
         * login callback handler config must be prefixed with listener prefix
         * and SASL mechanism name in lower-case. For example,
         * listener.name.sasl_ssl.scram-sha-256.sasl.login.callback.handler.class=com.example.CustomScramLoginCallbackHandler.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginCallbackHandlerClass(
                java.lang.String saslLoginCallbackHandlerClass) {
            doSetProperty("saslLoginCallbackHandlerClass", saslLoginCallbackHandlerClass);
            return this;
        }
        /**
         * The fully qualified name of a class that implements the Login
         * interface. For brokers, login config must be prefixed with listener
         * prefix and SASL mechanism name in lower-case. For example,
         * listener.name.sasl_ssl.scram-sha-256.sasl.login.class=com.example.CustomScramLogin.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginClass(
                java.lang.String saslLoginClass) {
            doSetProperty("saslLoginClass", saslLoginClass);
            return this;
        }
        /**
         * The amount of buffer time before credential expiration to maintain
         * when refreshing a credential, in seconds. If a refresh would
         * otherwise occur closer to expiration than the number of buffer
         * seconds then the refresh will be moved up to maintain as much of the
         * buffer time as possible. Legal values are between 0 and 3600 (1
         * hour); a default value of 300 (5 minutes) is used if no value is
         * specified. This value and sasl.login.refresh.min.period.seconds are
         * both ignored if their sum exceeds the remaining lifetime of a
         * credential. Currently applies only to OAUTHBEARER.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Default: 300
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginRefreshBufferSeconds(
                short saslLoginRefreshBufferSeconds) {
            doSetProperty("saslLoginRefreshBufferSeconds", saslLoginRefreshBufferSeconds);
            return this;
        }
        /**
         * The desired minimum time for the login refresh thread to wait before
         * refreshing a credential, in seconds. Legal values are between 0 and
         * 900 (15 minutes); a default value of 60 (1 minute) is used if no
         * value is specified. This value and sasl.login.refresh.buffer.seconds
         * are both ignored if their sum exceeds the remaining lifetime of a
         * credential. Currently applies only to OAUTHBEARER.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Default: 60
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginRefreshMinPeriodSeconds(
                short saslLoginRefreshMinPeriodSeconds) {
            doSetProperty("saslLoginRefreshMinPeriodSeconds", saslLoginRefreshMinPeriodSeconds);
            return this;
        }
        /**
         * Login refresh thread will sleep until the specified window factor
         * relative to the credential's lifetime has been reached, at which time
         * it will try to refresh the credential. Legal values are between 0.5
         * (50%) and 1.0 (100%) inclusive; a default value of 0.8 (80%) is used
         * if no value is specified. Currently applies only to OAUTHBEARER.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.8
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginRefreshWindowFactor(
                double saslLoginRefreshWindowFactor) {
            doSetProperty("saslLoginRefreshWindowFactor", saslLoginRefreshWindowFactor);
            return this;
        }
        /**
         * The maximum amount of random jitter relative to the credential's
         * lifetime that is added to the login refresh thread's sleep time.
         * Legal values are between 0 and 0.25 (25%) inclusive; a default value
         * of 0.05 (5%) is used if no value is specified. Currently applies only
         * to OAUTHBEARER.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.05
         * Group: security
         */
        default VertxKafkaComponentBuilder saslLoginRefreshWindowJitter(
                double saslLoginRefreshWindowJitter) {
            doSetProperty("saslLoginRefreshWindowJitter", saslLoginRefreshWindowJitter);
            return this;
        }
        /**
         * SASL mechanism used for client connections. This may be any mechanism
         * for which a security provider is available. GSSAPI is the default
         * mechanism.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: GSSAPI
         * Group: security
         */
        default VertxKafkaComponentBuilder saslMechanism(
                java.lang.String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. Valid values are:
         * PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: PLAINTEXT
         * Group: security
         */
        default VertxKafkaComponentBuilder securityProtocol(
                java.lang.String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of configurable creator classes each returning a provider
         * implementing security algorithms. These classes should implement the
         * org.apache.kafka.common.security.auth.SecurityProviderCreator
         * interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder securityProviders(
                java.lang.String securityProviders) {
            doSetProperty("securityProviders", securityProviders);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol. By default all the available cipher suites are
         * supported.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslCipherSuites(
                java.lang.String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. The default is
         * 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2'
         * otherwise. With the default value for Java 11, clients and servers
         * will prefer TLSv1.3 if both support it and fallback to TLSv1.2
         * otherwise (assuming both support at least TLSv1.2). This default
         * should be fine for most cases. Also see the config documentation for
         * ssl.protocol.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         */
        default VertxKafkaComponentBuilder sslEnabledProtocols(
                java.lang.String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https
         * Group: security
         */
        default VertxKafkaComponentBuilder sslEndpointIdentificationAlgorithm(
                java.lang.String sslEndpointIdentificationAlgorithm) {
            doSetProperty("sslEndpointIdentificationAlgorithm", sslEndpointIdentificationAlgorithm);
            return this;
        }
        /**
         * The class of type
         * org.apache.kafka.common.security.auth.SslEngineFactory to provide
         * SSLEngine objects. Default value is
         * org.apache.kafka.common.security.ssl.DefaultSslEngineFactory.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslEngineFactoryClass(
                java.lang.String sslEngineFactoryClass) {
            doSetProperty("sslEngineFactoryClass", sslEngineFactoryClass);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: SunX509
         * Group: security
         */
        default VertxKafkaComponentBuilder sslKeymanagerAlgorithm(
                java.lang.String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The password of the private key in the key store file. This is
         * optional for client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslKeyPassword(
                java.lang.String sslKeyPassword) {
            doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }
        /**
         * The location of the key store file. This is optional for client and
         * can be used for two-way authentication for client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslKeystoreLocation(
                java.lang.String sslKeystoreLocation) {
            doSetProperty("sslKeystoreLocation", sslKeystoreLocation);
            return this;
        }
        /**
         * The store password for the key store file. This is optional for
         * client and only needed if ssl.keystore.location is configured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslKeystorePassword(
                java.lang.String sslKeystorePassword) {
            doSetProperty("sslKeystorePassword", sslKeystorePassword);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: JKS
         * Group: security
         */
        default VertxKafkaComponentBuilder sslKeystoreType(
                java.lang.String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. The default is
         * 'TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.
         * This value should be fine for most use cases. Allowed values in
         * recent JVMs are 'TLSv1.2' and 'TLSv1.3'. 'TLS', 'TLSv1.1', 'SSL',
         * 'SSLv2' and 'SSLv3' may be supported in older JVMs, but their usage
         * is discouraged due to known security vulnerabilities. With the
         * default value for this config and 'ssl.enabled.protocols', clients
         * will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'.
         * If this config is set to 'TLSv1.2', clients will not use 'TLSv1.3'
         * even if it is one of the values in ssl.enabled.protocols and the
         * server only supports 'TLSv1.3'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TLSv1.2
         * Group: security
         */
        default VertxKafkaComponentBuilder sslProtocol(
                java.lang.String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslProvider(
                java.lang.String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The SecureRandom PRNG implementation to use for SSL cryptography
         * operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslSecureRandomImplementation(
                java.lang.String sslSecureRandomImplementation) {
            doSetProperty("sslSecureRandomImplementation", sslSecureRandomImplementation);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: PKIX
         * Group: security
         */
        default VertxKafkaComponentBuilder sslTrustmanagerAlgorithm(
                java.lang.String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The location of the trust store file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslTruststoreLocation(
                java.lang.String sslTruststoreLocation) {
            doSetProperty("sslTruststoreLocation", sslTruststoreLocation);
            return this;
        }
        /**
         * The password for the trust store file. If a password is not set
         * access to the truststore is still available, but integrity checking
         * is disabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default VertxKafkaComponentBuilder sslTruststorePassword(
                java.lang.String sslTruststorePassword) {
            doSetProperty("sslTruststorePassword", sslTruststorePassword);
            return this;
        }
        /**
         * The file format of the trust store file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: JKS
         * Group: security
         */
        default VertxKafkaComponentBuilder sslTruststoreType(
                java.lang.String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
    }

    class VertxKafkaComponentBuilderImpl
            extends
                AbstractComponentBuilder<VertxKafkaComponent>
            implements
                VertxKafkaComponentBuilder {
        @Override
        protected VertxKafkaComponent buildConcreteComponent() {
            return new VertxKafkaComponent();
        }
        private org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration getOrCreateConfiguration(
                org.apache.camel.component.vertx.kafka.VertxKafkaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((VertxKafkaComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bootstrapServers": getOrCreateConfiguration((VertxKafkaComponent) component).setBootstrapServers((java.lang.String) value); return true;
            case "clientDnsLookup": getOrCreateConfiguration((VertxKafkaComponent) component).setClientDnsLookup((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((VertxKafkaComponent) component).setClientId((java.lang.String) value); return true;
            case "configuration": ((VertxKafkaComponent) component).setConfiguration((org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration) value); return true;
            case "connectionsMaxIdleMs": getOrCreateConfiguration((VertxKafkaComponent) component).setConnectionsMaxIdleMs((long) value); return true;
            case "headerFilterStrategy": getOrCreateConfiguration((VertxKafkaComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "interceptorClasses": getOrCreateConfiguration((VertxKafkaComponent) component).setInterceptorClasses((java.lang.String) value); return true;
            case "metadataMaxAgeMs": getOrCreateConfiguration((VertxKafkaComponent) component).setMetadataMaxAgeMs((long) value); return true;
            case "metricReporters": getOrCreateConfiguration((VertxKafkaComponent) component).setMetricReporters((java.lang.String) value); return true;
            case "metricsNumSamples": getOrCreateConfiguration((VertxKafkaComponent) component).setMetricsNumSamples((int) value); return true;
            case "metricsRecordingLevel": getOrCreateConfiguration((VertxKafkaComponent) component).setMetricsRecordingLevel((java.lang.String) value); return true;
            case "metricsSampleWindowMs": getOrCreateConfiguration((VertxKafkaComponent) component).setMetricsSampleWindowMs((long) value); return true;
            case "partitionId": getOrCreateConfiguration((VertxKafkaComponent) component).setPartitionId((java.lang.Integer) value); return true;
            case "receiveBufferBytes": getOrCreateConfiguration((VertxKafkaComponent) component).setReceiveBufferBytes((int) value); return true;
            case "reconnectBackoffMaxMs": getOrCreateConfiguration((VertxKafkaComponent) component).setReconnectBackoffMaxMs((long) value); return true;
            case "reconnectBackoffMs": getOrCreateConfiguration((VertxKafkaComponent) component).setReconnectBackoffMs((long) value); return true;
            case "requestTimeoutMs": getOrCreateConfiguration((VertxKafkaComponent) component).setRequestTimeoutMs((int) value); return true;
            case "retryBackoffMs": getOrCreateConfiguration((VertxKafkaComponent) component).setRetryBackoffMs((long) value); return true;
            case "sendBufferBytes": getOrCreateConfiguration((VertxKafkaComponent) component).setSendBufferBytes((int) value); return true;
            case "allowAutoCreateTopics": getOrCreateConfiguration((VertxKafkaComponent) component).setAllowAutoCreateTopics((boolean) value); return true;
            case "autoCommitIntervalMs": getOrCreateConfiguration((VertxKafkaComponent) component).setAutoCommitIntervalMs((int) value); return true;
            case "autoOffsetReset": getOrCreateConfiguration((VertxKafkaComponent) component).setAutoOffsetReset((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((VertxKafkaComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "checkCrcs": getOrCreateConfiguration((VertxKafkaComponent) component).setCheckCrcs((boolean) value); return true;
            case "clientRack": getOrCreateConfiguration((VertxKafkaComponent) component).setClientRack((java.lang.String) value); return true;
            case "defaultApiTimeoutMs": getOrCreateConfiguration((VertxKafkaComponent) component).setDefaultApiTimeoutMs((int) value); return true;
            case "enableAutoCommit": getOrCreateConfiguration((VertxKafkaComponent) component).setEnableAutoCommit((boolean) value); return true;
            case "excludeInternalTopics": getOrCreateConfiguration((VertxKafkaComponent) component).setExcludeInternalTopics((boolean) value); return true;
            case "fetchMaxBytes": getOrCreateConfiguration((VertxKafkaComponent) component).setFetchMaxBytes((int) value); return true;
            case "fetchMaxWaitMs": getOrCreateConfiguration((VertxKafkaComponent) component).setFetchMaxWaitMs((int) value); return true;
            case "fetchMinBytes": getOrCreateConfiguration((VertxKafkaComponent) component).setFetchMinBytes((int) value); return true;
            case "groupId": getOrCreateConfiguration((VertxKafkaComponent) component).setGroupId((java.lang.String) value); return true;
            case "groupInstanceId": getOrCreateConfiguration((VertxKafkaComponent) component).setGroupInstanceId((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((VertxKafkaComponent) component).setHeartbeatIntervalMs((int) value); return true;
            case "isolationLevel": getOrCreateConfiguration((VertxKafkaComponent) component).setIsolationLevel((java.lang.String) value); return true;
            case "keyDeserializer": getOrCreateConfiguration((VertxKafkaComponent) component).setKeyDeserializer((java.lang.String) value); return true;
            case "maxPartitionFetchBytes": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxPartitionFetchBytes((int) value); return true;
            case "maxPollIntervalMs": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxPollIntervalMs((int) value); return true;
            case "maxPollRecords": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxPollRecords((int) value); return true;
            case "partitionAssignmentStrategy": getOrCreateConfiguration((VertxKafkaComponent) component).setPartitionAssignmentStrategy((java.lang.String) value); return true;
            case "seekToOffset": getOrCreateConfiguration((VertxKafkaComponent) component).setSeekToOffset((java.lang.Long) value); return true;
            case "seekToPosition": getOrCreateConfiguration((VertxKafkaComponent) component).setSeekToPosition((java.lang.String) value); return true;
            case "sessionTimeoutMs": getOrCreateConfiguration((VertxKafkaComponent) component).setSessionTimeoutMs((int) value); return true;
            case "valueDeserializer": getOrCreateConfiguration((VertxKafkaComponent) component).setValueDeserializer((java.lang.String) value); return true;
            case "acks": getOrCreateConfiguration((VertxKafkaComponent) component).setAcks((java.lang.String) value); return true;
            case "batchSize": getOrCreateConfiguration((VertxKafkaComponent) component).setBatchSize((int) value); return true;
            case "bufferMemory": getOrCreateConfiguration((VertxKafkaComponent) component).setBufferMemory((long) value); return true;
            case "compressionType": getOrCreateConfiguration((VertxKafkaComponent) component).setCompressionType((java.lang.String) value); return true;
            case "deliveryTimeoutMs": getOrCreateConfiguration((VertxKafkaComponent) component).setDeliveryTimeoutMs((int) value); return true;
            case "enableIdempotence": getOrCreateConfiguration((VertxKafkaComponent) component).setEnableIdempotence((boolean) value); return true;
            case "keySerializer": getOrCreateConfiguration((VertxKafkaComponent) component).setKeySerializer((java.lang.String) value); return true;
            case "lazyStartProducer": ((VertxKafkaComponent) component).setLazyStartProducer((boolean) value); return true;
            case "lingerMs": getOrCreateConfiguration((VertxKafkaComponent) component).setLingerMs((long) value); return true;
            case "maxBlockMs": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxBlockMs((long) value); return true;
            case "maxInFlightRequestsPerConnection": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxInFlightRequestsPerConnection((int) value); return true;
            case "maxRequestSize": getOrCreateConfiguration((VertxKafkaComponent) component).setMaxRequestSize((int) value); return true;
            case "metadataMaxIdleMs": getOrCreateConfiguration((VertxKafkaComponent) component).setMetadataMaxIdleMs((long) value); return true;
            case "partitionerClass": getOrCreateConfiguration((VertxKafkaComponent) component).setPartitionerClass((java.lang.String) value); return true;
            case "retries": getOrCreateConfiguration((VertxKafkaComponent) component).setRetries((int) value); return true;
            case "transactionalId": getOrCreateConfiguration((VertxKafkaComponent) component).setTransactionalId((java.lang.String) value); return true;
            case "transactionTimeoutMs": getOrCreateConfiguration((VertxKafkaComponent) component).setTransactionTimeoutMs((int) value); return true;
            case "valueSerializer": getOrCreateConfiguration((VertxKafkaComponent) component).setValueSerializer((java.lang.String) value); return true;
            case "autowiredEnabled": ((VertxKafkaComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "vertx": ((VertxKafkaComponent) component).setVertx((io.vertx.core.Vertx) value); return true;
            case "vertxOptions": ((VertxKafkaComponent) component).setVertxOptions((io.vertx.core.VertxOptions) value); return true;
            case "saslClientCallbackHandlerClass": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslClientCallbackHandlerClass((java.lang.String) value); return true;
            case "saslJaasConfig": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslJaasConfig((java.lang.String) value); return true;
            case "saslKerberosKinitCmd": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslKerberosKinitCmd((java.lang.String) value); return true;
            case "saslKerberosMinTimeBeforeRelogin": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslKerberosMinTimeBeforeRelogin((long) value); return true;
            case "saslKerberosServiceName": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslKerberosServiceName((java.lang.String) value); return true;
            case "saslKerberosTicketRenewJitter": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslKerberosTicketRenewJitter((double) value); return true;
            case "saslKerberosTicketRenewWindowFactor": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslKerberosTicketRenewWindowFactor((double) value); return true;
            case "saslLoginCallbackHandlerClass": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginCallbackHandlerClass((java.lang.String) value); return true;
            case "saslLoginClass": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginClass((java.lang.String) value); return true;
            case "saslLoginRefreshBufferSeconds": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginRefreshBufferSeconds((short) value); return true;
            case "saslLoginRefreshMinPeriodSeconds": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginRefreshMinPeriodSeconds((short) value); return true;
            case "saslLoginRefreshWindowFactor": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginRefreshWindowFactor((double) value); return true;
            case "saslLoginRefreshWindowJitter": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslLoginRefreshWindowJitter((double) value); return true;
            case "saslMechanism": getOrCreateConfiguration((VertxKafkaComponent) component).setSaslMechanism((java.lang.String) value); return true;
            case "securityProtocol": getOrCreateConfiguration((VertxKafkaComponent) component).setSecurityProtocol((java.lang.String) value); return true;
            case "securityProviders": getOrCreateConfiguration((VertxKafkaComponent) component).setSecurityProviders((java.lang.String) value); return true;
            case "sslCipherSuites": getOrCreateConfiguration((VertxKafkaComponent) component).setSslCipherSuites((java.lang.String) value); return true;
            case "sslEnabledProtocols": getOrCreateConfiguration((VertxKafkaComponent) component).setSslEnabledProtocols((java.lang.String) value); return true;
            case "sslEndpointIdentificationAlgorithm": getOrCreateConfiguration((VertxKafkaComponent) component).setSslEndpointIdentificationAlgorithm((java.lang.String) value); return true;
            case "sslEngineFactoryClass": getOrCreateConfiguration((VertxKafkaComponent) component).setSslEngineFactoryClass((java.lang.String) value); return true;
            case "sslKeymanagerAlgorithm": getOrCreateConfiguration((VertxKafkaComponent) component).setSslKeymanagerAlgorithm((java.lang.String) value); return true;
            case "sslKeyPassword": getOrCreateConfiguration((VertxKafkaComponent) component).setSslKeyPassword((java.lang.String) value); return true;
            case "sslKeystoreLocation": getOrCreateConfiguration((VertxKafkaComponent) component).setSslKeystoreLocation((java.lang.String) value); return true;
            case "sslKeystorePassword": getOrCreateConfiguration((VertxKafkaComponent) component).setSslKeystorePassword((java.lang.String) value); return true;
            case "sslKeystoreType": getOrCreateConfiguration((VertxKafkaComponent) component).setSslKeystoreType((java.lang.String) value); return true;
            case "sslProtocol": getOrCreateConfiguration((VertxKafkaComponent) component).setSslProtocol((java.lang.String) value); return true;
            case "sslProvider": getOrCreateConfiguration((VertxKafkaComponent) component).setSslProvider((java.lang.String) value); return true;
            case "sslSecureRandomImplementation": getOrCreateConfiguration((VertxKafkaComponent) component).setSslSecureRandomImplementation((java.lang.String) value); return true;
            case "sslTrustmanagerAlgorithm": getOrCreateConfiguration((VertxKafkaComponent) component).setSslTrustmanagerAlgorithm((java.lang.String) value); return true;
            case "sslTruststoreLocation": getOrCreateConfiguration((VertxKafkaComponent) component).setSslTruststoreLocation((java.lang.String) value); return true;
            case "sslTruststorePassword": getOrCreateConfiguration((VertxKafkaComponent) component).setSslTruststorePassword((java.lang.String) value); return true;
            case "sslTruststoreType": getOrCreateConfiguration((VertxKafkaComponent) component).setSslTruststoreType((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}