/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jolt.JoltComponent;

/**
 * JSON to JSON transformation using JOLT.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface JoltComponentBuilderFactory {

    /**
     * JOLT (camel-jolt)
     * JSON to JSON transformation using JOLT.
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     */
    static JoltComponentBuilder jolt() {
        return new JoltComponentBuilderImpl();
    }

    /**
     * Builder for the JOLT component.
     */
    interface JoltComponentBuilder extends ComponentBuilder<JoltComponent> {
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default JoltComponentBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default JoltComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default JoltComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Explicitly sets the Transform to use. If not set a Transform
         * specified by the transformDsl will be created.
         * 
         * The option is a: <code>com.bazaarvoice.jolt.Transform</code> type.
         * 
         * Group: advanced
         */
        default JoltComponentBuilder transform(
                com.bazaarvoice.jolt.Transform transform) {
            doSetProperty("transform", transform);
            return this;
        }
    }

    class JoltComponentBuilderImpl
            extends
                AbstractComponentBuilder<JoltComponent>
            implements
                JoltComponentBuilder {
        @Override
        protected JoltComponent buildConcreteComponent() {
            return new JoltComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "allowTemplateFromHeader": ((JoltComponent) component).setAllowTemplateFromHeader((boolean) value); return true;
            case "lazyStartProducer": ((JoltComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((JoltComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "transform": ((JoltComponent) component).setTransform((com.bazaarvoice.jolt.Transform) value); return true;
            default: return false;
            }
        }
    }
}