/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GitEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":localPath";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "git".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "localPath", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(16);
        props.add("basicPropertyBinding");
        props.add("remotePath");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("branchName");
        props.add("tagName");
        props.add("type");
        props.add("allowEmpty");
        props.add("password");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("localPath");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("remoteName");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

