/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.stomp.StompComponent;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class StompComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private StompConfiguration getOrCreateConfiguration(StompComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new StompConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        StompComponent target = (StompComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)StompComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)StompComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "brokerurl": 
            case "brokerURL": {
                this.getOrCreateConfiguration(target).setBrokerURL((String)StompComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((StompConfiguration)StompComponentConfigurer.property((CamelContext)camelContext, StompConfiguration.class, (Object)value));
                return true;
            }
            case "customheaders": 
            case "customHeaders": {
                this.getOrCreateConfiguration(target).setCustomHeaders((Properties)StompComponentConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)StompComponentConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost((String)StompComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)StompComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "login": {
                this.getOrCreateConfiguration(target).setLogin((String)StompComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "passcode": {
                this.getOrCreateConfiguration(target).setPasscode((String)StompComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters((SSLContextParameters)StompComponentConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters((Boolean)StompComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "version": {
                this.getOrCreateConfiguration(target).setVersion((String)StompComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        StompComponent target = (StompComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "brokerurl": 
            case "brokerURL": {
                return this.getOrCreateConfiguration(target).getBrokerURL();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "customheaders": 
            case "customHeaders": {
                return this.getOrCreateConfiguration(target).getCustomHeaders();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "login": {
                return this.getOrCreateConfiguration(target).getLogin();
            }
            case "passcode": {
                return this.getOrCreateConfiguration(target).getPasscode();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "version": {
                return this.getOrCreateConfiguration(target).getVersion();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("brokerURL", String.class);
        map.put("customHeaders", Properties.class);
        map.put("host", String.class);
        map.put("version", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("configuration", StompConfiguration.class);
        map.put("headerFilterStrategy", HeaderFilterStrategy.class);
        map.put("login", String.class);
        map.put("passcode", String.class);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("useGlobalSslContextParameters", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

