/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.ChildReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.google.drive.GoogleDriveComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class GoogleDriveFilesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveFilesConverter.class);

    private GoogleDriveFilesConverter() {
    }

    @Converter
    public static com.google.api.services.drive.model.File genericFileToGoogleDriveFile(GenericFile<?> file, Exchange exchange) throws Exception {
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setTitle(f.getName());
            FileContent mediaContent = new FileContent(null, f);
            if (exchange != null) {
                exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
                exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            }
            return fileMetadata;
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setTitle(file.getFileName());
            InputStreamContent mediaContent = new InputStreamContent(null, is);
            exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
            exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            return fileMetadata;
        }
        return null;
    }

    @Converter(allowNull=true)
    public static InputStream download(com.google.api.services.drive.model.File fileMetadata, Exchange exchange) throws Exception {
        if (fileMetadata.getDownloadUrl() != null && fileMetadata.getDownloadUrl().length() > 0) {
            try {
                HttpResponse resp = GoogleDriveFilesConverter.getClient(exchange).getRequestFactory().buildGetRequest(new GenericUrl(fileMetadata.getDownloadUrl())).execute();
                return resp.getContent();
            }
            catch (IOException e) {
                LOG.debug("Could not download file.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Converter
    public static String downloadContentAsString(com.google.api.services.drive.model.File fileMetadata, Exchange exchange) throws Exception {
        InputStream is = GoogleDriveFilesConverter.download(fileMetadata, exchange);
        if (is != null) {
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)is);
        }
        return null;
    }

    @Converter
    public static ChildReference genericStringToChildReference(String payload, Exchange exchange) throws Exception {
        if (payload != null) {
            ChildReference childReference = new ChildReference();
            childReference.setId(payload);
            return childReference;
        }
        return null;
    }

    private static Drive getClient(Exchange exchange) {
        GoogleDriveComponent component = (GoogleDriveComponent)exchange.getContext().getComponent("google-drive", GoogleDriveComponent.class);
        return component.getClient(component.getConfiguration());
    }
}

