/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
@Configurer
public class GoogleDriveConfiguration {
    private static final List<String> DEFAULT_SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive.file", "https://www.googleapis.com/auth/drive.apps.readonly", "https://www.googleapis.com/auth/drive.metadata.readonly", "https://www.googleapis.com/auth/drive");
    @UriPath
    @Metadata(required=true)
    private GoogleDriveApiName apiName;
    @UriPath(enums="copy,delete,get,getIdForEmail,insert,list,patch,stop,touch,trash,untrash,update,watch")
    @Metadata(required=true)
    private String methodName;
    @UriParam
    private List<String> scopes = DEFAULT_SCOPES;
    @UriParam
    private String clientId;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String refreshToken;
    @UriParam
    private String applicationName;

    public GoogleDriveApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(GoogleDriveApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }
}

