/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerSupport;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxPlatformHttpServer
extends ServiceSupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpServer.class);
    private final VertxPlatformHttpServerConfiguration configuration;
    private CamelContext context;
    private ExecutorService executor;
    private boolean localVertx;
    private Vertx vertx;
    private Router router;
    private Router subRouter;
    private HttpServer server;

    public VertxPlatformHttpServer(VertxPlatformHttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        if (ServiceHelper.isStarted((Object)((Object)this))) {
            throw new IllegalArgumentException("Can't set the Vertx instance after the service has been started");
        }
        this.vertx = vertx;
        this.localVertx = false;
    }

    protected void doInit() throws Exception {
        this.vertx = this.lookupVertx();
        if (this.vertx != null) {
            LOGGER.info("Found Vert.x instance in registry: {}", (Object)this.vertx);
        }
    }

    protected void doStart() throws Exception {
        this.initializeServer();
        this.startServer();
    }

    protected void doStop() throws Exception {
        this.stopServer();
        this.stopVertx();
        if (this.executor != null) {
            this.context.getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    protected Vertx lookupVertx() {
        return (Vertx)CamelContextHelper.findByType((CamelContext)this.context, Vertx.class);
    }

    protected Vertx createVertxInstance() {
        VertxOptions options = (VertxOptions)CamelContextHelper.findByType((CamelContext)this.context, VertxOptions.class);
        if (options == null) {
            options = new VertxOptions();
        }
        return Vertx.vertx((VertxOptions)options);
    }

    protected void initializeServer() {
        if (this.vertx == null) {
            this.vertx = this.lookupVertx();
            if (this.vertx == null) {
                LOGGER.info("Creating new Vert.x instance");
                this.vertx = this.createVertxInstance();
                this.localVertx = true;
            }
        }
        this.router = Router.router((Vertx)this.vertx);
        this.subRouter = Router.router((Vertx)this.vertx);
        if (this.configuration.getCors().isEnabled()) {
            this.subRouter.route().handler(VertxPlatformHttpServerSupport.createCorsHandler(this.configuration));
        }
        this.router.mountSubRouter(this.configuration.getPath(), this.subRouter);
        this.context.getRegistry().bind("platform-http-router", (Object)new VertxPlatformHttpRouter(this.vertx, this.subRouter){

            @Override
            public Handler<RoutingContext> bodyHandler() {
                return VertxPlatformHttpServerSupport.createBodyHandler(VertxPlatformHttpServer.this.configuration);
            }
        });
    }

    protected void startServer() {
        HttpServerOptions options = new HttpServerOptions();
        VertxPlatformHttpServerSupport.configureSSL(options, this.configuration, this.context);
        this.executor = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "platform-http-service");
        this.server = this.vertx.createHttpServer(options);
        CompletableFuture.runAsync(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.requestHandler((Handler)this.router).listen(this.configuration.getBindPort(), this.configuration.getBindHost(), result -> {
                try {
                    if (result.failed()) {
                        LOGGER.warn("Failed to start Vert.x HttpServer on {}:{}, reason: {}", new Object[]{this.configuration.getBindHost(), this.configuration.getBindPort(), result.cause().getMessage()});
                        throw new RuntimeException(result.cause());
                    }
                    LOGGER.info("Vert.x HttpServer started on {}:{}", (Object)this.configuration.getBindHost(), (Object)this.configuration.getBindPort());
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.executor).toCompletableFuture().join();
    }

    protected void stopServer() {
        if (this.server == null) {
            return;
        }
        try {
            CompletableFuture.runAsync(() -> {
                CountDownLatch latch = new CountDownLatch(1);
                this.context.removeComponent("platform-http");
                this.server.close(result -> {
                    try {
                        if (result.failed()) {
                            LOGGER.warn("Failed to close Vert.x HttpServer reason: {}", (Object)result.cause().getMessage());
                            throw new RuntimeException(result.cause());
                        }
                        LOGGER.info("Vert.x HttpServer stopped");
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }, this.executor).toCompletableFuture().join();
        }
        finally {
            this.server = null;
        }
    }

    protected void stopVertx() {
        if (this.vertx == null || this.localVertx) {
            return;
        }
        try {
            CompletableFuture.runAsync(() -> {
                CountDownLatch latch = new CountDownLatch(1);
                this.vertx.close(result -> {
                    try {
                        if (result.failed()) {
                            LOGGER.warn("Failed to close Vert.x reason: {}", (Object)result.cause().getMessage());
                            throw new RuntimeException(result.cause());
                        }
                        LOGGER.info("Vert.x stopped");
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }, this.executor).toCompletableFuture().join();
        }
        finally {
            this.vertx = null;
            this.localVertx = false;
        }
    }
}

