/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class IrcEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":hostname:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "irc".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("basicPropertyBinding");
        props.add("keys");
        props.add("synchronous");
        props.add("sslContextParameters");
        props.add("autoRejoin");
        props.add("onTopic");
        props.add("colors");
        props.add("onQuit");
        props.add("hostname");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("nickname");
        props.add("nickPassword");
        props.add("trustManager");
        props.add("persistent");
        props.add("onKick");
        props.add("commandTimeout");
        props.add("exchangePattern");
        props.add("namesOnJoin");
        props.add("realname");
        props.add("onPart");
        props.add("onReply");
        props.add("lazyStartProducer");
        props.add("onJoin");
        props.add("channels");
        props.add("onPrivmsg");
        props.add("port");
        props.add("exceptionHandler");
        props.add("onMode");
        props.add("onNick");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("password");
        secretProps.add("nickPassword");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

