/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JettyHttp9EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jetty".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(35);
        props.add("basicPropertyBinding");
        props.add("enableMultipartFilter");
        props.add("synchronous");
        props.add("sslContextParameters");
        props.add("enableJmx");
        props.add("mapHttpMessageBody");
        props.add("sessionSupport");
        props.add("useContinuation");
        props.add("sendServerVersion");
        props.add("bridgeErrorHandler");
        props.add("httpUri");
        props.add("headerFilterStrategy");
        props.add("transferException");
        props.add("enableCORS");
        props.add("muteException");
        props.add("filterInitParameters");
        props.add("httpMethodRestrict");
        props.add("eagerCheckContentAvailable");
        props.add("httpBinding");
        props.add("sendDateHeader");
        props.add("continuationTimeout");
        props.add("matchOnUriPrefix");
        props.add("exchangePattern");
        props.add("chunked");
        props.add("filters");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("async");
        props.add("responseBufferSize");
        props.add("disableStreamCache");
        props.add("handlers");
        props.add("multipartFilter");
        props.add("optionsEnabled");
        props.add("mapHttpMessageHeaders");
        props.add("traceEnabled");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

