/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ClientEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":uriPath";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "iec60870-client".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "uriPath", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(23);
        props.add("basicPropertyBinding");
        props.add("synchronous");
        props.add("dataModuleOptions");
        props.add("exchangePattern");
        props.add("timeout3");
        props.add("timeZone");
        props.add("maxUnacknowledged");
        props.add("timeout1");
        props.add("timeout2");
        props.add("causeSourceAddress");
        props.add("protocolOptions");
        props.add("adsuAddressType");
        props.add("informationObjectAddressType");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("ignoreDaylightSavingTime");
        props.add("acknowledgeWindow");
        props.add("causeOfTransmissionType");
        props.add("connectionId");
        props.add("ignoreBackgroundScan");
        props.add("exceptionHandler");
        props.add("connectionTimeout");
        props.add("uriPath");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

