/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.azure.storage.queue.QueueEndpoint;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class QueueEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QueueEndpoint target = (QueueEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                target.getConfiguration().setAccessKey((String)QueueEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                target.getConfiguration().setAutoDiscoverClient((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "createqueue": 
            case "createQueue": {
                target.getConfiguration().setCreateQueue((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                target.getConfiguration().setCredentials((StorageSharedKeyCredential)QueueEndpointConfigurer.property((CamelContext)camelContext, StorageSharedKeyCredential.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)QueueEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)QueueEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessages": 
            case "maxMessages": {
                target.getConfiguration().setMaxMessages((Integer)QueueEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messageid": 
            case "messageId": {
                target.getConfiguration().setMessageId((String)QueueEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation((QueueOperationDefinition)((Object)QueueEndpointConfigurer.property((CamelContext)camelContext, QueueOperationDefinition.class, (Object)value)));
                return true;
            }
            case "popreceipt": 
            case "popReceipt": {
                target.getConfiguration().setPopReceipt((String)QueueEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                target.getConfiguration().setServiceClient((QueueServiceClient)QueueEndpointConfigurer.property((CamelContext)camelContext, QueueServiceClient.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)QueueEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                target.getConfiguration().setTimeToLive((Duration)QueueEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "timeout": {
                target.getConfiguration().setTimeout((Duration)QueueEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                target.getConfiguration().setVisibilityTimeout((Duration)QueueEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QueueEndpoint target = (QueueEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return target.getConfiguration().getAccessKey();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return target.getConfiguration().isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "createqueue": 
            case "createQueue": {
                return target.getConfiguration().isCreateQueue();
            }
            case "credentials": {
                return target.getConfiguration().getCredentials();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessages": 
            case "maxMessages": {
                return target.getConfiguration().getMaxMessages();
            }
            case "messageid": 
            case "messageId": {
                return target.getConfiguration().getMessageId();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "popreceipt": 
            case "popReceipt": {
                return target.getConfiguration().getPopReceipt();
            }
            case "serviceclient": 
            case "serviceClient": {
                return target.getConfiguration().getServiceClient();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "timetolive": 
            case "timeToLive": {
                return target.getConfiguration().getTimeToLive();
            }
            case "timeout": {
                return target.getConfiguration().getTimeout();
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                return target.getConfiguration().getVisibilityTimeout();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("accountName", String.class);
        map.put("queueName", String.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("serviceClient", QueueServiceClient.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("createQueue", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("operation", QueueOperationDefinition.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("maxMessages", Integer.class);
        map.put("messageId", String.class);
        map.put("popReceipt", String.class);
        map.put("timeout", Duration.class);
        map.put("timeToLive", Duration.class);
        map.put("visibilityTimeout", Duration.class);
        map.put("accessKey", String.class);
        map.put("credentials", StorageSharedKeyCredential.class);
        ALL_OPTIONS = map;
    }
}

