/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ResteasyEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "resteasy".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(43);
        props.add("basicPropertyBinding");
        props.add("getWithBody");
        props.add("synchronous");
        props.add("ignoreResponseBody");
        props.add("mapHttpMessageBody");
        props.add("proxyClientClass");
        props.add("servletName");
        props.add("httpMethod");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("deleteWithBody");
        props.add("httpUri");
        props.add("transferException");
        props.add("headerFilterStrategy");
        props.add("copyHeaders");
        props.add("customHostHeader");
        props.add("bridgeEndpoint");
        props.add("clearExpiredCookies");
        props.add("setHttpResponseDuringProcessing");
        props.add("muteException");
        props.add("skipServletProcessing");
        props.add("throwExceptionOnFailure");
        props.add("httpMethodRestrict");
        props.add("eagerCheckContentAvailable");
        props.add("matchOnUriPrefix");
        props.add("exchangePattern");
        props.add("chunked");
        props.add("connectionClose");
        props.add("useSystemProperties");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("okStatusCodeRange");
        props.add("async");
        props.add("responseBufferSize");
        props.add("lazyStartProducer");
        props.add("preserveHostHeader");
        props.add("disableStreamCache");
        props.add("resteasyMethod");
        props.add("optionsEnabled");
        props.add("mapHttpMessageHeaders");
        props.add("traceEnabled");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

