/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.corda;

import java.util.Map;
import net.corda.core.node.services.vault.PageSpecification;
import net.corda.core.node.services.vault.QueryCriteria;
import net.corda.core.node.services.vault.Sort;
import org.apache.camel.CamelContext;
import org.apache.camel.component.corda.CordaComponent;
import org.apache.camel.component.corda.CordaConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class CordaComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private CordaConfiguration getOrCreateConfiguration(CordaComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new CordaConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CordaComponent target = (CordaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)CordaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)CordaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((CordaConfiguration)CordaComponentConfigurer.property((CamelContext)camelContext, CordaConfiguration.class, (Object)value));
                return true;
            }
            case "contractstateclass": 
            case "contractStateClass": {
                this.getOrCreateConfiguration(target).setContractStateClass((Class)CordaComponentConfigurer.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "flowlogicarguments": 
            case "flowLogicArguments": {
                this.getOrCreateConfiguration(target).setFlowLogicArguments((Object[])CordaComponentConfigurer.property((CamelContext)camelContext, Object[].class, (Object)value));
                return true;
            }
            case "flowlogicclass": 
            case "flowLogicClass": {
                this.getOrCreateConfiguration(target).setFlowLogicClass((Class)CordaComponentConfigurer.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)CordaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((String)CordaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pagespecification": 
            case "pageSpecification": {
                this.getOrCreateConfiguration(target).setPageSpecification((PageSpecification)CordaComponentConfigurer.property((CamelContext)camelContext, PageSpecification.class, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)CordaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "processsnapshot": 
            case "processSnapshot": {
                this.getOrCreateConfiguration(target).setProcessSnapshot((Boolean)CordaComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "querycriteria": 
            case "queryCriteria": {
                this.getOrCreateConfiguration(target).setQueryCriteria((QueryCriteria)CordaComponentConfigurer.property((CamelContext)camelContext, QueryCriteria.class, (Object)value));
                return true;
            }
            case "sort": {
                this.getOrCreateConfiguration(target).setSort((Sort)CordaComponentConfigurer.property((CamelContext)camelContext, Sort.class, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)CordaComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CordaComponent target = (CordaComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "contractstateclass": 
            case "contractStateClass": {
                return this.getOrCreateConfiguration(target).getContractStateClass();
            }
            case "flowlogicarguments": 
            case "flowLogicArguments": {
                return this.getOrCreateConfiguration(target).getFlowLogicArguments();
            }
            case "flowlogicclass": 
            case "flowLogicClass": {
                return this.getOrCreateConfiguration(target).getFlowLogicClass();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "pagespecification": 
            case "pageSpecification": {
                return this.getOrCreateConfiguration(target).getPageSpecification();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "processsnapshot": 
            case "processSnapshot": {
                return this.getOrCreateConfiguration(target).isProcessSnapshot();
            }
            case "querycriteria": 
            case "queryCriteria": {
                return this.getOrCreateConfiguration(target).getQueryCriteria();
            }
            case "sort": {
                return this.getOrCreateConfiguration(target).getSort();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("configuration", CordaConfiguration.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("pageSpecification", PageSpecification.class);
        map.put("processSnapshot", Boolean.TYPE);
        map.put("sort", Sort.class);
        map.put("contractStateClass", Class.class);
        map.put("flowLogicArguments", Object[].class);
        map.put("flowLogicClass", Class.class);
        map.put("queryCriteria", QueryCriteria.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("operation", String.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("password", String.class);
        map.put("username", String.class);
        ALL_OPTIONS = map;
    }
}

