/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.etcd.EtcdStatsEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class EtcdStatsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EtcdStatsEndpoint target = (EtcdStatsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "fromindex": 
            case "fromIndex": {
                target.getConfiguration().setFromIndex((Long)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword((String)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "recursive": {
                target.getConfiguration().setRecursive((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptyexchangeontimeout": 
            case "sendEmptyExchangeOnTimeout": {
                target.getConfiguration().setSendEmptyExchangeOnTimeout((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "servicepath": 
            case "servicePath": {
                target.getConfiguration().setServicePath((String)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters((SSLContextParameters)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                target.getConfiguration().setTimeToLive((Integer)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "timeout": {
                target.getConfiguration().setTimeout((Long)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "uris": {
                target.getConfiguration().setUris((String)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": 
            case "userName": {
                target.getConfiguration().setUserName((String)EtcdStatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EtcdStatsEndpoint target = (EtcdStatsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "fromindex": 
            case "fromIndex": {
                return target.getConfiguration().getFromIndex();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "recursive": {
                return target.getConfiguration().isRecursive();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptyexchangeontimeout": 
            case "sendEmptyExchangeOnTimeout": {
                return target.getConfiguration().isSendEmptyExchangeOnTimeout();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "servicepath": 
            case "servicePath": {
                return target.getConfiguration().getServicePath();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "timetolive": 
            case "timeToLive": {
                return target.getConfiguration().getTimeToLive();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "timeout": {
                return target.getConfiguration().getTimeout();
            }
            case "uris": {
                return target.getConfiguration().getUris();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": 
            case "userName": {
                return target.getConfiguration().getUserName();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("path", String.class);
        map.put("recursive", Boolean.TYPE);
        map.put("servicePath", String.class);
        map.put("timeout", Long.class);
        map.put("uris", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("sendEmptyExchangeOnTimeout", Boolean.TYPE);
        map.put("sendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("fromIndex", Long.TYPE);
        map.put("pollStrategy", PollingConsumerPollStrategy.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("timeToLive", Integer.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        map.put("backoffErrorThreshold", Integer.TYPE);
        map.put("backoffIdleThreshold", Integer.TYPE);
        map.put("backoffMultiplier", Integer.TYPE);
        map.put("delay", Long.TYPE);
        map.put("greedy", Boolean.TYPE);
        map.put("initialDelay", Long.TYPE);
        map.put("repeatCount", Long.TYPE);
        map.put("runLoggingLevel", LoggingLevel.class);
        map.put("scheduledExecutorService", ScheduledExecutorService.class);
        map.put("scheduler", Object.class);
        map.put("schedulerProperties", Map.class);
        map.put("startScheduler", Boolean.TYPE);
        map.put("timeUnit", TimeUnit.class);
        map.put("useFixedDelay", Boolean.TYPE);
        map.put("password", String.class);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("userName", String.class);
        ALL_OPTIONS = map;
    }
}

