/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.component.tika.TikaOperation;
import org.apache.camel.component.tika.TikaParseOutputFormat;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.tika.config.TikaConfig;

public class TikaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        TikaEndpoint target = (TikaEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)TikaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "tikaconfig": 
            case "tikaConfig": {
                target.getTikaConfiguration().setTikaConfig((TikaConfig)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaConfig.class, (Object)value));
                return true;
            }
            case "tikaconfiguri": 
            case "tikaConfigUri": {
                target.getTikaConfiguration().setTikaConfigUri((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tikaparseoutputencoding": 
            case "tikaParseOutputEncoding": {
                target.getTikaConfiguration().setTikaParseOutputEncoding((String)TikaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tikaparseoutputformat": 
            case "tikaParseOutputFormat": {
                target.getTikaConfiguration().setTikaParseOutputFormat((TikaParseOutputFormat)((Object)TikaEndpointConfigurer.property((CamelContext)camelContext, TikaParseOutputFormat.class, (Object)value)));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        TikaEndpoint target = (TikaEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "tikaconfig": 
            case "tikaConfig": {
                return target.getTikaConfiguration().getTikaConfig();
            }
            case "tikaconfiguri": 
            case "tikaConfigUri": {
                return target.getTikaConfiguration().getTikaConfigUri();
            }
            case "tikaparseoutputencoding": 
            case "tikaParseOutputEncoding": {
                return target.getTikaConfiguration().getTikaParseOutputEncoding();
            }
            case "tikaparseoutputformat": 
            case "tikaParseOutputFormat": {
                return target.getTikaConfiguration().getTikaParseOutputFormat();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("operation", TikaOperation.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("tikaConfig", TikaConfig.class);
        map.put("tikaConfigUri", String.class);
        map.put("tikaParseOutputEncoding", String.class);
        map.put("tikaParseOutputFormat", TikaParseOutputFormat.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

