/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.Protocol;
import com.amazonaws.services.kafka.AWSKafka;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws.msk.MSKOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class MSKConfiguration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam(label="producer")
    private AWSKafka mskClient;
    @UriParam(label="producer", secret=true)
    private String accessKey;
    @UriParam(label="producer", secret=true)
    private String secretKey;
    @UriParam(label="producer")
    @Metadata(required=true)
    private MSKOperations operation;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(label="producer")
    private String proxyHost;
    @UriParam(label="producer")
    private Integer proxyPort;
    @UriParam
    private String region;
    @UriParam(label="common", defaultValue="true")
    private boolean autoDiscoverClient = true;

    public AWSKafka getMskClient() {
        return this.mskClient;
    }

    public void setMskClient(AWSKafka mskClient) {
        this.mskClient = mskClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public MSKOperations getOperation() {
        return this.operation;
    }

    public void setOperation(MSKOperations operation) {
        this.operation = operation;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public MSKConfiguration copy() {
        try {
            return (MSKConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

