/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class BlobServiceEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":containerOrBlobUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "azure-blob".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "containerOrBlobUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(25);
        props.add("basicPropertyBinding");
        props.add("credentials");
        props.add("synchronous");
        props.add("credentialsAccountKey");
        props.add("blobOffset");
        props.add("validateClientURI");
        props.add("bridgeErrorHandler");
        props.add("closeStreamAfterRead");
        props.add("closeStreamAfterWrite");
        props.add("useFlatListing");
        props.add("containerOrBlobUri");
        props.add("blobMetadata");
        props.add("streamReadSize");
        props.add("dataLength");
        props.add("exchangePattern");
        props.add("publicForRead");
        props.add("streamWriteSize");
        props.add("azureBlobClient");
        props.add("lazyStartProducer");
        props.add("blobPrefix");
        props.add("fileDir");
        props.add("blobType");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("credentialsAccountName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("credentialsAccountKey");
        secretProps.add("credentialsAccountName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

