/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.consumer;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.wordpress.WordpressConfiguration;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWordpressConsumer
extends ScheduledPollConsumer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWordpressConsumer.class);
    private WordpressConfiguration configuration;

    public AbstractWordpressConsumer(WordpressEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = endpoint.getConfiguration();
        this.initConsumer();
    }

    public AbstractWordpressConsumer(WordpressEndpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super((Endpoint)endpoint, processor, scheduledExecutorService);
        this.configuration = endpoint.getConfiguration();
        this.initConsumer();
    }

    public WordpressConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isGreedy() {
        return false;
    }

    private void initConsumer() {
        this.configureService(this.configuration);
    }

    protected void configureService(WordpressConfiguration configuration) {
    }

    protected abstract int poll() throws Exception;

    protected final void process(Object result) {
        block2: {
            Exchange exchange = this.getEndpoint().createExchange();
            try {
                exchange.getIn().setBody(result);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                if (exchange.getException() == null) break block2;
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

