/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.disruptor.DisruptorEndpoint;
import org.apache.camel.component.disruptor.DisruptorProducerType;
import org.apache.camel.component.disruptor.DisruptorWaitStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class DisruptorEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DisruptorEndpoint target = (DisruptorEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "blockwhenfull": 
            case "blockWhenFull": {
                target.setBlockWhenFull((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                target.setConcurrentConsumers((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipleconsumers": 
            case "multipleConsumers": {
                target.setMultipleConsumers((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "producertype": 
            case "producerType": {
                target.setProducerType((DisruptorProducerType)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorProducerType.class, (Object)value)));
                return true;
            }
            case "size": {
                target.setSize((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeout": {
                target.setTimeout(((Duration)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "waitfortasktocomplete": 
            case "waitForTaskToComplete": {
                target.setWaitForTaskToComplete((WaitForTaskToComplete)DisruptorEndpointConfigurer.property((CamelContext)camelContext, WaitForTaskToComplete.class, (Object)value));
                return true;
            }
            case "waitstrategy": 
            case "waitStrategy": {
                target.setWaitStrategy((DisruptorWaitStrategy)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorWaitStrategy.class, (Object)value)));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DisruptorEndpoint target = (DisruptorEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "blockwhenfull": 
            case "blockWhenFull": {
                return target.isBlockWhenFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return target.getConcurrentConsumers();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "multipleconsumers": 
            case "multipleConsumers": {
                return target.isMultipleConsumers();
            }
            case "producertype": 
            case "producerType": {
                return target.getProducerType();
            }
            case "size": {
                return target.getSize();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "timeout": {
                return target.getTimeout();
            }
            case "waitfortasktocomplete": 
            case "waitForTaskToComplete": {
                return target.getWaitForTaskToComplete();
            }
            case "waitstrategy": 
            case "waitStrategy": {
                return target.getWaitStrategy();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("name", String.class);
        map.put("size", Integer.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("concurrentConsumers", Integer.TYPE);
        map.put("multipleConsumers", Boolean.TYPE);
        map.put("waitStrategy", DisruptorWaitStrategy.class);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("blockWhenFull", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("producerType", DisruptorProducerType.class);
        map.put("timeout", Long.TYPE);
        map.put("waitForTaskToComplete", WaitForTaskToComplete.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

